/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.calc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.component.CalculationComponent;
import org.eclipse.scada.configuration.component.CalculationModule;
import org.eclipse.scada.configuration.component.InputDefinition;
import org.eclipse.scada.configuration.component.MovingAverageModule;
import org.eclipse.scada.configuration.component.OutputDefinition;
import org.eclipse.scada.configuration.component.OutputSpecification;
import org.eclipse.scada.configuration.component.generator.calc.CalculationComponentGenerator;
import org.eclipse.scada.configuration.component.generator.calc.Calculations;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.MovingAverage;
import org.eclipse.scada.configuration.world.osgi.MovingAverageItem;
import org.eclipse.scada.configuration.world.osgi.MovingAverageReferenceType;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.utils.str.StringHelper;

public class MovingAverageModuleGenerator
extends CalculationComponentGenerator<MovingAverageModule> {
    private final Map<MasterServer, MovingAverage> danglingMap = new HashMap<MasterServer, MovingAverage>();
    private final Map<MasterServer, MovingAverage> map = new HashMap<MasterServer, MovingAverage>();

    public MovingAverageModuleGenerator(CalculationComponent calculationComponent) {
        super(calculationComponent, MovingAverageModule.class);
    }

    public CreationRequest<MovingAverageItem> createAverageItem(ItemCreator creator, MovingAverageReferenceType type) {
        MovingAverageItem averageItem = OsgiFactory.eINSTANCE.createMovingAverageItem();
        averageItem.setType(type);
        return creator.addItem((Item)averageItem);
    }

    @Override
    public void createItems(ItemCreator creator, MovingAverageModule implementation) {
        for (OutputDefinition output : this.calculationComponent.getOutputs()) {
            OutputSpecification outputSpec = Calculations.findSpecification((CalculationModule)implementation, output);
            MovingAverageReferenceType type = MovingAverageReferenceType.get((String)output.getName());
            if (type == null) {
                throw new IllegalStateException(String.format("Moving average reference type %s is unknown. Use any of: %s.", output.getName(), StringHelper.join((Object[])MovingAverageReferenceType.values(), (String)", ")));
            }
            CreationRequest<MovingAverageItem> c = this.createAverageItem(creator, type);
            c.localTags((Collection)output.getLocalTag());
            c.customizationTags((Collection)output.getCustomizationTags());
            c.dataType(outputSpec.getDataType());
            c.addMasterListener((MasterListener)new MasterListener<MovingAverageItem>(){

                public void setMaster(MovingAverageItem item, GeneratorContext.MasterContext master) {
                    MovingAverage average = (MovingAverage)MovingAverageModuleGenerator.this.map.get(master.getImplementation());
                    item.setSource(average);
                }
            });
            c.create();
        }
    }

    @Override
    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master, MovingAverageModule implementation) {
        MovingAverage average = OsgiFactory.eINSTANCE.createMovingAverage();
        average.setName(this.makeId());
        master.getImplementation().getMovingAverages().add((Object)average);
        average.setNullRange(implementation.getNullRange());
        average.setRange(implementation.getRange());
        average.setTrigger(implementation.getTrigger());
        average.setTriggerOnly(Boolean.valueOf(implementation.isTriggerOnly()));
        this.map.put(master.getImplementation(), average);
        this.danglingMap.put(master.getImplementation(), average);
        InputDefinition input = Calculations.findSingleInputByName((Collection<InputDefinition>)this.calculationComponent.getInputs(), "input");
        if (input == null) {
            throw new IllegalStateException("Moving average must contain have an input item set");
        }
        average.setItem((Item)input.createReference());
    }

    @Override
    public void finish(FinishContext context) {
        for (Map.Entry<MasterServer, MovingAverage> entry : this.danglingMap.entrySet()) {
            entry.getValue().setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)entry.getKey(), (Item)entry.getValue().getItem()));
        }
        super.finish(context);
    }
}

