/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.connection;

import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.generator.DataComponentGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.Connection;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.SourceItem;

public abstract class ConnectionAnalyzerGenerator
extends DataComponentGenerator {
    private static final String NAME_FORMAT_STATE = "org.eclipse.scada.%s.master.analyzer.connectionService.%s.state.state";
    private static final String NAME_FORMAT_CONNECTED = "org.eclipse.scada.%s.master.analyzer.connectionService.%s.state.connected";

    public ConnectionAnalyzerGenerator(DataComponent dataComponent) {
        super(dataComponent);
    }

    protected void createForConnection(ItemCreator creator, ConnectionProvider connectionProvider) {
        CreationRequest c = creator.createSelfItem(null);
        c.localTags(new String[]{"CON"});
        c.dataType(DataType.BOOLEAN);
        c.customizationTags(new String[]{"input"});
        c.addMasterListener((MasterListener)new ConnectionMasterHandlerImpl(NAME_FORMAT_CONNECTED, connectionProvider));
        c.create();
        c = creator.createSelfItem(null);
        c.localTags(new String[]{"STATE"});
        c.dataType(DataType.STRING);
        c.customizationTags(new String[]{"input"});
        c.addMasterListener((MasterListener)new ConnectionMasterHandlerImpl(NAME_FORMAT_STATE, connectionProvider));
        c.create();
    }

    private final class ConnectionMasterHandlerImpl
    implements MasterListener<SourceItem> {
        private final ConnectionProvider connectionProvider;
        private final String format;

        private ConnectionMasterHandlerImpl(String format, ConnectionProvider connectionProvider) {
            this.format = format;
            this.connectionProvider = connectionProvider;
        }

        public void setMaster(SourceItem item, GeneratorContext.MasterContext master) {
            Connection connection = this.connectionProvider.getConnection(master.getImplementation());
            String tag = connection.getTypeTag();
            String id = connection.getName();
            item.setSourceName(String.format(this.format, tag, id));
        }
    }

    protected static interface ConnectionProvider {
        public Connection getConnection(MasterServer var1);
    }
}

