/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.global;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.GlobalizeComponent;
import org.eclipse.scada.configuration.component.generator.ComponentGenerator;
import org.eclipse.scada.configuration.component.generator.ItemCreatorImpl;
import org.eclipse.scada.configuration.component.lib.create.CaptureItemCreator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemSource;
import org.eclipse.scada.configuration.component.lib.create.ItemSources;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.infrastructure.MasterServer;

public class GlobalizeGenerator
extends ComponentGenerator
implements ItemSource {
    private final GlobalizeComponent globalize;

    public GlobalizeGenerator(GlobalizeComponent component) {
        super((Component)component);
        this.globalize = component;
    }

    public void createItems(ItemCreator itemCreator) {
        for (DataComponent component : this.globalize.getComponents()) {
            Map<List<String>, CaptureItemCreator.ItemCreation> items = this.createItems(component);
            for (Map.Entry<List<String>, CaptureItemCreator.ItemCreation> entry : items.entrySet()) {
                CreationRequest req = itemCreator.createImportItem(this.globalize.getSourceMaster(), entry.getValue().getItem().getName());
                req.request(entry.getValue().getCustomizationRequest());
                req.addCustomizationTags(new String[]{"globalized"});
                req.incrementGlobalizationLevel();
                req.localTags((Collection)entry.getKey());
                req.create();
            }
        }
    }

    private Map<List<String>, CaptureItemCreator.ItemCreation> createItems(DataComponent component) {
        HashMap<List<String>, CaptureItemCreator.ItemCreation> result = new HashMap<List<String>, CaptureItemCreator.ItemCreation>();
        ItemSource source = ItemSources.createItemSource((Component)component);
        CaptureItemCreator creator = new CaptureItemCreator((Component)component, result);
        source.createItems((ItemCreator)creator);
        return result;
    }

    public void generate(GenerationContext context) {
        MasterServer master = this.globalize.getSourceMaster().getMaster();
        GeneratorContext.MasterContext mappedMaster = this.context.getMasterContext(master);
        if (mappedMaster == null) {
            throw new IllegalStateException(String.format("No mapped master found for: %s", master));
        }
        this.createItems(this.createItemCreator(mappedMaster));
    }

    protected ItemCreator createItemCreator(GeneratorContext.MasterContext master) {
        return new ItemCreatorImpl(this.context, master, (Component)this.globalize);
    }
}

