/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.simple;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.component.DeltaValue;
import org.eclipse.scada.configuration.component.SingleValue;
import org.eclipse.scada.configuration.component.generator.simple.AbstractSingleValueGenerator;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.DeltaItem;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;

public class DeltaValueGenerator
extends AbstractSingleValueGenerator {
    private final DeltaValue deltaValue;
    private final Map<MasterServer, DeltaItem> items = new HashMap<MasterServer, DeltaItem>();

    public DeltaValueGenerator(DeltaValue deltaValue) {
        super((SingleValue)deltaValue);
        this.deltaValue = deltaValue;
    }

    @Override
    protected CreationRequest<?> createRequest(ItemCreator itemCreator) {
        DeltaItem item = OsgiFactory.eINSTANCE.createDeltaItem();
        item.setSource((Item)this.deltaValue.getSource().createReference());
        CreationRequest req = itemCreator.addItem((Item)item);
        req.addMasterListener((MasterListener)new MasterListener<DeltaItem>(){

            public void setMaster(DeltaItem item, GeneratorContext.MasterContext master) {
                DeltaValueGenerator.this.items.put(master.getImplementation(), item);
            }
        });
        return req;
    }

    @Override
    public void finish(FinishContext context) {
        super.finish(context);
        for (Map.Entry<MasterServer, DeltaItem> entry : this.items.entrySet()) {
            entry.getValue().setSource(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)entry.getKey(), (Item)entry.getValue().getSource()));
        }
    }
}

