/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.configuration.setup.common.PostgresSetupModule;
import org.eclipse.scada.utils.str.ExtendedPropertiesReplacer;
import org.eclipse.scada.utils.str.StringReplacer;

public class Postgres {
    public static final String POSTGRES_VERSION_KEY = "postgresql.version";
    public static final String POSTGRES_USER_KEY = "postgresql.user";
    public static final String POSTGRES_GROUP_KEY = "postgresql.group";
    public static final String POSTGRES_VERSION_VALUE = "9.3";
    public static final String PLUGIN_ID = "org.eclipse.scada.configuration.setup.common";
    protected final PostgresSetupModule postgres;

    public Postgres(PostgresSetupModule postgres) {
        this.postgres = postgres;
    }

    public InputStream openResource(String uriString) throws MalformedURLException, IOException {
        return this.makeURL(uriString).openStream();
    }

    public URL makeURL(String uriString) throws MalformedURLException {
        URI uri = URI.createURI((String)uriString);
        uri = uri.resolve(this.postgres.eResource().getURI());
        return new URL(uri.toString());
    }

    protected String getHostBasedAccessFile(Map<String, String> properties) {
        return this.expand("${postgresql.hostBasedAccessFile:${postgresql.configurationDirectory}/pg_hba.conf}", properties);
    }

    protected String getConfigurationFile(Map<String, String> properties) {
        return this.expand("${postgresql.configurationFile:${postgresql.configurationDirectory}/postgresql.conf}", properties);
    }

    protected String expand(String string, Map<String, String> properties) {
        return StringReplacer.replace((String)string, (StringReplacer.ReplaceSource)new ExtendedPropertiesReplacer(properties, true), (Pattern)StringReplacer.DEFAULT_PATTERN);
    }
}

