/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.ComponentReferenceInputDefinition;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.lib.create.CaptureItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemSource;
import org.eclipse.scada.configuration.component.lib.create.ItemSources;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class ComponentReferenceInputDefinitionValidator
extends TypedValidator<ComponentReferenceInputDefinition> {
    public ComponentReferenceInputDefinitionValidator() {
        super(ComponentReferenceInputDefinition.class);
    }

    protected void validate(ComponentReferenceInputDefinition ref, ValidationContext ctx) {
        if (!(ref.eContainer() instanceof DataComponent)) {
            return;
        }
        if (!(ref.getComponent() instanceof DataComponent)) {
            return;
        }
        DataComponent dc = (DataComponent)ref.eContainer();
        DataComponent refComp = (DataComponent)ref.getComponent();
        for (MasterServer m : dc.getMasterOn()) {
            if (refComp.getMasterOn().contains((Object)m)) continue;
            ctx.add("\"{0}\" of data component \"{1}\" references to a component \"{2}\" that is not available on the master server \"'{3}\".", new Object[]{ref, dc, refComp, m});
        }
        for (MasterServer m : dc.getMasterOn()) {
            this.validateRef(m, ref, ctx);
        }
    }

    private Map<List<String>, CaptureItemCreator.ItemCreation> createItems(Component component) {
        HashMap<List<String>, CaptureItemCreator.ItemCreation> result = new HashMap<List<String>, CaptureItemCreator.ItemCreation>();
        ItemSource source = ItemSources.createItemSource((Component)component);
        CaptureItemCreator creator = new CaptureItemCreator(component, result);
        source.createItems((ItemCreator)creator);
        return result;
    }

    private void validateRef(MasterServer m, ComponentReferenceInputDefinition ref, ValidationContext ctx) {
        Map<List<String>, CaptureItemCreator.ItemCreation> itemResult = this.createItems(ref.getComponent());
        CaptureItemCreator.ItemCreation refItem = itemResult.get(ref.getLocalTag());
        if (refItem == null) {
            ctx.add("The reference points to an invalid item (LocalTags: {0}) on the component: {1}", new Object[]{ref.getLocalTag(), ref.getComponent()});
        }
    }
}

