/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.validation;

import java.util.LinkedList;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.GlobalizeComponent;
import org.eclipse.scada.configuration.infrastructure.MasterImport;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class GlobalizeComponentValidator
extends TypedValidator<GlobalizeComponent> {
    public GlobalizeComponentValidator() {
        super(GlobalizeComponent.class);
    }

    protected void validate(GlobalizeComponent glob, ValidationContext context) {
        if (glob.getComponents().contains((Object)glob)) {
            context.add("The globalization component imports itself. This is not allowed.", new Object[0]);
            return;
        }
        MasterImport sourceMaster = glob.getSourceMaster();
        if (sourceMaster != null) {
            LinkedList<DataComponent> illegal = new LinkedList<DataComponent>();
            for (DataComponent dc : glob.getComponents()) {
                if (dc.getMasterOn().contains((Object)sourceMaster.getImportedMaster())) continue;
                illegal.add(dc);
            }
            if (!illegal.isEmpty()) {
                context.add(Severity.ERROR, illegal.toArray(), "The globalization component imports components through MasterImport {0} but some referenced components do not run there.", new Object[]{sourceMaster});
            }
        }
    }
}

