/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.MasterImport;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.world.WorldFactory;

public class MasterImportItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public MasterImportItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addImportedMasterPropertyDescriptor(object);
            this.addIdPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addImportedMasterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MasterImport_importedMaster_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MasterImport_importedMaster_feature", "_UI_MasterImport_type"), (EStructuralFeature)InfrastructurePackage.Literals.MASTER_IMPORT__IMPORTED_MASTER, true, false, true, null, null, null));
    }

    protected void addIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_MasterImport_id_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_MasterImport_id_feature", "_UI_MasterImport_type"), (EStructuralFeature)InfrastructurePackage.Literals.MASTER_IMPORT__ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(InfrastructurePackage.Literals.MASTER_IMPORT__CREDENTIALS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/MasterImport"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        MasterImport mi;
        String id = ((MasterImport)object).getId();
        if (id == null || id.isEmpty()) {
            id = "<unnamed>";
        }
        if ((mi = (MasterImport)object).getImportedMaster() != null) {
            MasterServer im = mi.getImportedMaster();
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)im, IItemLabelProvider.class);
            String imLabel = labelProvider != null ? labelProvider.getText((Object)im) : "" + im;
            return String.format("%s from %s as %s", this.getString("_UI_MasterImport_type"), imLabel, id);
        }
        return String.valueOf(this.getString("_UI_MasterImport_type")) + " " + id;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(MasterImport.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(InfrastructurePackage.Literals.MASTER_IMPORT__CREDENTIALS, WorldFactory.eINSTANCE.createUsernamePasswordCredentials()));
        newChildDescriptors.add(this.createChildParameter(InfrastructurePackage.Literals.MASTER_IMPORT__CREDENTIALS, WorldFactory.eINSTANCE.createPasswordCredentials()));
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

