/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.ui;

import java.net.URISyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.scada.configuration.recipe.Definition;
import org.eclipse.scada.configuration.recipe.Profile;
import org.eclipse.scada.configuration.recipe.ui.RecipeHelper;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionContributionItem
extends ContributionItem {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionContributionItem.class);
    private final Definition definition;
    private final IContainer parent;

    public DefinitionContributionItem(IContainer parent, Definition definition) {
        this.parent = parent;
        this.definition = definition;
    }

    public void fill(Menu menu, int index) {
        String profileName;
        MenuItem item = new MenuItem(menu, 0, index);
        Profile profile = this.getProfile();
        final String name = this.definition.getName() == null ? "<unnamed>" : this.definition.getName();
        String string = profileName = profile != null ? profile.getName() : "default";
        if (profileName == null) {
            profileName = "<unnamed>";
        }
        item.setText(String.format("Run %s (%s)", name, profileName));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    DefinitionContributionItem.this.run(name);
                }
                catch (Exception e) {
                    logger.warn("Failed to run", (Throwable)e);
                    StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.recipe.ui", (Throwable)e), 4);
                }
            }
        });
    }

    protected Profile getProfile() {
        return null;
    }

    protected void run(String name) throws URISyntaxException {
        WorkspaceJob job = new WorkspaceJob(String.format("Run recipe: %s", name)){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    RecipeHelper.processFile(DefinitionContributionItem.this.parent, DefinitionContributionItem.this.definition, DefinitionContributionItem.this.getProfile(), monitor);
                }
                catch (Exception e) {
                    logger.warn("Failed to process", (Throwable)e);
                    return StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.recipe.ui", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setSystem(false);
        job.schedule();
    }
}

