/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scada.configuration.recipe.Definition;
import org.eclipse.scada.configuration.recipe.Profile;
import org.eclipse.scada.configuration.recipe.ui.DefinitionContributionItem;
import org.eclipse.scada.configuration.recipe.ui.ProfileContributionItem;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProfilesContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final String CONTENT_TYPE_ID = "org.eclipse.scada.configuration.recipe";
    private IServiceLocator serviceLocator;

    public ProfilesContribution() {
    }

    public ProfilesContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ISelectionService ss = (ISelectionService)this.serviceLocator.getService(ISelectionService.class);
        if (ss == null) {
            return new IContributionItem[0];
        }
        ISelection sel = ss.getSelection();
        LinkedList<IContributionItem> items = new LinkedList<IContributionItem>();
        this.addFromFileResource(items, sel);
        return items.toArray(new IContributionItem[items.size()]);
    }

    private void addFromFileResource(List<IContributionItem> defs, ISelection sel) {
        ModelLoader loader = new ModelLoader(Definition.class);
        for (IFile res : SelectionHelper.iterable((ISelection)sel, IFile.class)) {
            try {
                if (!CONTENT_TYPE_ID.equals(res.getContentDescription().getContentType().getId())) {
                }
            }
            catch (CoreException coreException) {}
            continue;
            try {
                Definition def = (Definition)loader.load(res.getLocationURI());
                if (def == null) continue;
                this.addDefinition(defs, res.getParent(), def);
            }
            catch (Exception e) {
                StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.recipe.ui", (Throwable)e), 1);
            }
        }
    }

    private void addDefinition(List<IContributionItem> items, IContainer parent, Definition def) {
        items.add((IContributionItem)new DefinitionContributionItem(parent, def));
        for (Profile p : def.getProfiles()) {
            items.add((IContributionItem)new ProfileContributionItem(parent, def, p));
        }
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

