/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.ui;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.scada.configuration.recipe.Definition;
import org.eclipse.scada.configuration.recipe.Profile;
import org.eclipse.scada.configuration.recipe.lib.Builder;
import org.eclipse.scada.configuration.recipe.lib.Recipe;
import org.eclipse.scada.configuration.utils.ModelLoader;

public final class RecipeHelper {
    private RecipeHelper() {
    }

    public static void processFile(IContainer parent, Definition definition, Profile profile, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(RecipeHelper.makeJobLabel(definition, profile), 100);
        IFolder output = parent.getFolder((IPath)new Path("output"));
        if (output.exists()) {
            output.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 9));
        }
        output.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        Builder builder = new Builder(definition, profile);
        Recipe recipe = builder.build();
        try {
            HashMap<String, IFolder> initialContent = new HashMap<String, IFolder>();
            initialContent.put("output", output);
            recipe.execute(initialContent, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
        }
        finally {
            monitor.done();
        }
    }

    protected static String makeJobLabel(Definition definition, Profile profile) {
        String name;
        String string = name = definition.getName() == null ? definition.getId() : definition.getName();
        if (profile == null) {
            return String.format("Running recipe: %s", name);
        }
        return String.format("Running recipe: %s (%s)", name, profile.getName());
    }

    public static void processFile(IResource file, IProgressMonitor monitor) throws Exception {
        ModelLoader loader = new ModelLoader(Definition.class);
        Definition def = (Definition)loader.load(file.getLocationURI());
        RecipeHelper.processFile(file.getParent(), def, null, monitor);
    }
}

