/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class DerivedAttributeAdapter
extends AdapterImpl {
    private final InternalEObject source;
    private final EStructuralFeature derivedFeature;
    private final List<EStructuralFeature> localFeatures = new ArrayList<EStructuralFeature>();
    private final Set<EStructuralFeature> dependantFeatures = new HashSet<EStructuralFeature>();
    private EStructuralFeature navigationFeature;
    private final AdapterImpl dependantAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() != 1) {
                return;
            }
            if (DerivedAttributeAdapter.this.dependantFeatures.contains(msg.getFeature())) {
                DerivedAttributeAdapter.this.notifyDerivedAttributeChange();
            }
        }
    };

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependantFeature);
        this.addLocalDependency(localFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependantFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addLocalDependency(localFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature) {
        this.source = (InternalEObject)source;
        this.derivedFeature = derivedFeature;
        source.eAdapters().add((Object)this);
    }

    public void addNavigatedDependency(EStructuralFeature navigationFeature, EStructuralFeature ... dependantFeatures) {
        this.dependantFeatures.addAll(Arrays.asList(dependantFeatures));
        this.navigationFeature = navigationFeature;
    }

    public void addLocalDependency(EStructuralFeature localFeature) {
        this.localFeatures.add(localFeature);
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeature() == null) {
            return;
        }
        if (notification.getFeature().equals(this.navigationFeature)) {
            switch (notification.getEventType()) {
                case 3: {
                    EObject added = (EObject)notification.getNewValue();
                    added.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 1: {
                    EObject newValue = (EObject)notification.getNewValue();
                    EObject oldValue = (EObject)notification.getOldValue();
                    if (oldValue != null) {
                        oldValue.eAdapters().remove((Object)this.dependantAdapter);
                    }
                    if (newValue == null) break;
                    newValue.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 4: {
                    EObject removed = (EObject)notification.getOldValue();
                    removed.eAdapters().remove((Object)this.dependantAdapter);
                    break;
                }
                default: {
                    return;
                }
            }
            this.notifyDerivedAttributeChange();
        } else if (this.localFeatures.contains(notification.getFeature())) {
            this.notifyDerivedAttributeChange();
        }
    }

    private void notifyDerivedAttributeChange() {
        if (this.source.eNotificationRequired()) {
            this.source.eNotify((Notification)new ENotificationImpl(this.source, 1, this.derivedFeature, null, this.source.eGet(this.derivedFeature, true, true)));
        }
    }
}

