/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.server.test;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.ide.server.test.PortValidator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class NgpExportPage
extends WizardPage {
    private DataBindingContext dbc;
    private final Set<Control> controls = new HashSet<Control>();
    private Button enable;
    private final WritableValue portValue = new WritableValue((Object)2199, Integer.class);

    public NgpExportPage() {
        super("ngpExportPage", "NGP Export", null);
    }

    public void createControl(Composite parent) {
        this.setTitle("Select NGP Export parameters");
        this.setDescription("Chose the NGP protocol parameters");
        this.dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        Composite wrapper = new Composite(parent, 0);
        this.setControl((Control)wrapper);
        wrapper.setLayout((Layout)new GridLayout(1, false));
        this.enable = new Button(wrapper, 32);
        this.enable.setText("Enable NGP exporter");
        this.enable.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.enable.setSelection(true);
        this.enable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NgpExportPage.this.updateEnablement();
            }
        });
        Group group = new Group(wrapper, 16);
        group.setText("TCP");
        group.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)group, 0);
        l.setText("TCP Port:");
        Spinner portSpinner = new Spinner((Composite)group, 2048);
        this.controls.add((Control)portSpinner);
        portSpinner.setIncrement(1);
        portSpinner.setMinimum(1);
        portSpinner.setMaximum(32766);
        portSpinner.setPageIncrement(10);
        portSpinner.setSelection(2199);
        portSpinner.setLayoutData((Object)this.withGap());
        Binding b = this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)portSpinner), (IObservableValue)this.portValue, new UpdateValueStrategy().setAfterConvertValidator((IValidator)new PortValidator()), null);
        ControlDecorationSupport.create((ValidationStatusProvider)b, (int)16384);
        Dialog.applyDialogFont((Control)wrapper);
    }

    protected GridData withGap() {
        GridData result = new GridData(1, 1, false, false);
        result.horizontalIndent = 10;
        return result;
    }

    protected void updateEnablement() {
        boolean state = this.enable.getSelection();
        for (Control c : this.controls) {
            c.setEnabled(state);
        }
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public ConnectionInformation getConnectionInformation() {
        if (!this.enable.getSelection()) {
            return null;
        }
        Integer port = this.getPort();
        if (port == null) {
            return null;
        }
        return ConnectionInformation.fromURI((String)String.format("da:ngp://0.0.0.0:%s", port));
    }

    private Integer getPort() {
        Object v = this.portValue.getValue();
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        return null;
    }
}

