/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.server.test;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class PortValidator
implements IValidator {
    private static final int MAX = 32766;
    private static final int MIN = 1;

    public IStatus validate(Object value) {
        if (!(value instanceof Number)) {
            return new Status(4, "org.eclipse.scada.ide.server.test", "Value must be a number");
        }
        int port = ((Number)value).intValue();
        if (port < 1 || port > 32766) {
            return new Status(4, "org.eclipse.scada.ide.server.test", String.format("Port number must be between %s and %s (inclusive)", 1, 32766));
        }
        if (port < 1024 && this.isUnix()) {
            return new Status(2, "org.eclipse.scada.ide.server.test", String.format("Port numbers below 1024 are reserved for privileged users (root) and may not be available for use.", new Object[0]));
        }
        return Status.OK_STATUS;
    }

    private boolean isUnix() {
        String os = Platform.getOS();
        return !"win32".equals(os);
    }
}

