/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.common.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.common.ScaledValue;
import org.eclipse.scada.configuration.component.common.lib.Helper;
import org.eclipse.scada.configuration.component.generator.AbstractDanglingGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.FormulaItem;
import org.eclipse.scada.configuration.world.osgi.FormulaItemInbound;
import org.eclipse.scada.configuration.world.osgi.FormulaItemOutbound;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.TypedItemReference;
import org.eclipse.scada.utils.str.StringReplacer;

public class ScaledValueGeneratorGenerator
extends AbstractDanglingGenerator {
    private static final Pattern PATTERN = Pattern.compile("@@(.*?)@@");
    private final ScaledValue generator;

    public ScaledValueGeneratorGenerator(ScaledValue generator) {
        super((DataComponent)generator);
        this.generator = generator;
    }

    public void createItems(ItemCreator itemCreator) {
        if (this.generator.getSourceItem() == null) {
            throw new IllegalStateException("'sourceItem' not set");
        }
        FormulaItem item = OsgiFactory.eINSTANCE.createFormulaItem();
        item.setScriptEngine("JavaScript");
        FormulaItemInbound inbound = OsgiFactory.eINSTANCE.createFormulaItemInbound();
        TypedItemReference ref = OsgiFactory.eINSTANCE.createTypedItemReference();
        ref.setName("A");
        ref.setItem((Item)this.generator.getSourceItem().createReference());
        ref.setType(DataType.FLOAT);
        inbound.getInputs().add((Object)ref);
        inbound.setInputFormula(this.makeInputFormula());
        item.setInbound(inbound);
        TypedItemReference ref2 = OsgiFactory.eINSTANCE.createTypedItemReference();
        ref2.setItem((Item)this.generator.getSourceItem().createReference());
        ref2.setType(DataType.FLOAT);
        FormulaItemOutbound outbound = OsgiFactory.eINSTANCE.createFormulaItemOutbound();
        outbound.setWriteValueVariableName("B");
        outbound.setOutputFormula(this.makeOutputFormula());
        outbound.setOutput(ref2);
        item.setOutbound(outbound);
        CreationRequest req = itemCreator.addItem((Item)item);
        req.localTags(new String[]{this.generator.getName()});
        req.dataType(this.generator.getDataType());
        req.customizationTags((Collection)this.generator.getCustomizationTags());
        req.information(this.generator.getShortDescription(), null, null);
        this.createFormulaItem(req);
    }

    private String makeOutputFormula() {
        StringBuilder sb = new StringBuilder();
        if (this.generator.isValidateRange()) {
            sb.append(Helper.loadResource("scaled.value.validate.js"));
        }
        sb.append(Helper.loadResource("scaled.value.formula.js")).append(';');
        HashMap<String, Object> properties = new HashMap<String, Object>(5);
        properties.put("value", "B");
        properties.put("outMin", this.generator.getInputMinimum());
        properties.put("outMax", this.generator.getInputMaximum());
        properties.put("inMin", this.generator.getOutputMinimum());
        properties.put("inMax", this.generator.getOutputMaximum());
        return StringReplacer.replace((String)sb.toString(), (StringReplacer.ReplaceSource)StringReplacer.newSource(properties), (Pattern)PATTERN);
    }

    private String makeInputFormula() {
        StringBuilder sb = new StringBuilder();
        if (this.generator.isValidateRange()) {
            sb.append(Helper.loadResource("scaled.value.validate.js"));
        }
        sb.append(Helper.loadResource("scaled.value.formula.js")).append(';');
        HashMap<String, Object> properties = new HashMap<String, Object>(5);
        properties.put("value", "A");
        properties.put("inMin", this.generator.getInputMinimum());
        properties.put("inMax", this.generator.getInputMaximum());
        properties.put("outMin", this.generator.getOutputMinimum());
        properties.put("outMax", this.generator.getOutputMaximum());
        return StringReplacer.replace((String)sb.toString(), (StringReplacer.ReplaceSource)StringReplacer.newSource(properties), (Pattern)PATTERN);
    }
}

