/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.hd.hdsspy.decorators;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.scada.hds.DataFileAccessorImpl;

public class TimeRangeDecorator
implements ILightweightLabelDecorator {
    private static final String CONTENT_TYPE = "org.eclipse.scada.hds.archive";
    private final DateFormat START = DateFormat.getDateTimeInstance();
    private final DateFormat END = DateFormat.getTimeInstance();

    public void decorate(Object element, IDecoration decoration) {
        try {
            IFile resource = (IFile)element;
            String timeframe = this.getTimeframe(resource);
            if (timeframe != null) {
                decoration.addSuffix(" " + timeframe);
            }
        }
        catch (Exception exception) {}
    }

    private String getTimeframe(IFile resource) throws Exception {
        String id = resource.getContentDescription().getContentType().getId();
        if (!id.equals(CONTENT_TYPE)) {
            return null;
        }
        DataFileAccessorImpl accessor = new DataFileAccessorImpl(resource.getLocation().toFile());
        try {
            Date start = accessor.getStart();
            Date end = accessor.getEnd();
            String string = String.format("%s -> %s", this.START.format(start), this.END.format(end));
            return string;
        }
        finally {
            accessor.dispose();
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

