/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus.lib;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.EquinoxDriver;
import org.eclipse.scada.configuration.infrastructure.lib.AbstractEquinoxDriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DeviceTypeValidator;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.lib.Endpoints;
import org.eclipse.scada.configuration.memory.TypeDefinition;
import org.eclipse.scada.configuration.memory.TypeHelper;
import org.eclipse.scada.configuration.memory.TypeSystem;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerFactory;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerModule;
import org.eclipse.scada.configuration.modbus.ModbusBlock;
import org.eclipse.scada.configuration.modbus.ModbusDevice;
import org.eclipse.scada.configuration.modbus.ModbusDriver;
import org.eclipse.scada.configuration.modbus.ModbusFactory;
import org.eclipse.scada.configuration.modbus.ModbusMaster;
import org.eclipse.scada.configuration.modbus.ModbusPackage;
import org.eclipse.scada.configuration.modbus.ModbusSlave;
import org.eclipse.scada.configuration.modbus.ProtocolType;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class DriverFactoryImpl
extends AbstractEquinoxDriverFactory<ModbusDriver> {
    private static final int MIN_ADDRESS = 0;
    private static final int MAX_ADDRESS = 65536;

    public DriverFactoryImpl() {
        this.addValidator((DriverValidator)new DeviceTypeValidator(ModbusDevice.class));
    }

    protected ModbusDriver createDriver() {
        return ModbusFactory.eINSTANCE.createModbusDriver();
    }

    protected void configureDriver(AbstractFactoryDriver driver, ModbusDriver result, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        MemoryManagerModule manager = MemoryManagerFactory.eINSTANCE.createMemoryManagerModule();
        result.getModules().add((Object)manager);
        for (Device device : driver.getDevices()) {
            if (!(device instanceof ModbusDevice)) {
                throw new IllegalStateException(String.format("Device type %s is not supported", device.getClass()));
            }
            if (manager.getTypeSystem() == null) {
                manager.setTypeSystem(((ModbusDevice)device).getTypeSystem());
            } else if (((ModbusDevice)device).getTypeSystem() != null && !manager.getTypeSystem().getName().equals(((ModbusDevice)device).getTypeSystem().getName())) {
                throw new IllegalStateException("All modbus devices must share the same type system");
            }
            this.createDevice(driver, result, (ModbusDevice)device, nodes);
        }
    }

    protected void createDevice(AbstractFactoryDriver driver, ModbusDriver result, ModbusDevice device, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        ModbusMaster master = ModbusFactory.eINSTANCE.createModbusMaster();
        master.setId(device.getName());
        result.getMasters().add((Object)master);
        Endpoint ep = Endpoints.registerEndpoint((Node)nodes.get(device.getNode()), (int)device.getPort(), null, (String)"Modbus Device Endpoint");
        master.setEndpoint(ep);
        master.setProtocolType(device.getProtocolType());
        master.setInterFrameDelay(device.getInterFrameDelay());
        master.getSlaves().addAll(EcoreUtil.copyAll((Collection)device.getSlaves()));
    }

    protected void performValidation(ValidationContext ctx, EquinoxDriver driver) {
        super.performValidation(ctx, driver);
        HashSet<TypeSystem> typeSystems = new HashSet<TypeSystem>();
        for (Device device : driver.getDevices()) {
            if (!(device instanceof ModbusDevice)) {
                throw new IllegalStateException(String.format("Device type %s is not supported", device.getClass()));
            }
            typeSystems.add(((ModbusDevice)device).getTypeSystem());
            this.validateDevice(ctx, driver, (ModbusDevice)device);
        }
        if (typeSystems.size() > 1) {
            ctx.add((EStructuralFeature)ModbusPackage.Literals.MODBUS_DEVICE__TYPE_SYSTEM, "All modbus devices of one driver instance must share the same type system ({0})", new Object[]{typeSystems});
        }
    }

    private void validateDevice(ValidationContext ctx, EquinoxDriver driver, ModbusDevice device) {
        if (device.getProtocolType() == ProtocolType.TCP && device.getInterFrameDelay() != null) {
            ctx.add(Severity.ERROR, new Object[]{device, ModbusPackage.Literals.MODBUS_DEVICE__INTER_FRAME_DELAY}, "InterFrameDelay must not be set for TCP devices.", new Object[0]);
        }
        for (ModbusSlave slave : device.getSlaves()) {
            if (device.getProtocolType() == ProtocolType.RTU && (slave.getUnitAddress() == 0 || slave.getUnitAddress() > 247)) {
                ctx.add(Severity.ERROR, new Object[]{slave, ModbusPackage.Literals.MODBUS_SLAVE__UNIT_ADDRESS}, "Unit address {0} is invalid. Must be greater than 0 (zero) and less than 248.", new Object[]{slave.getUnitAddress()});
            }
            for (ModbusBlock block : slave.getBlocks()) {
                if (block.getCount() <= 0) {
                    ctx.add(Severity.ERROR, new Object[]{block, ModbusPackage.Literals.MODBUS_BLOCK__COUNT}, "Block size must be positive and greater than zero", new Object[0]);
                }
                if (block.getPeriod() <= 0L) {
                    ctx.add(Severity.ERROR, new Object[]{block, ModbusPackage.Literals.MODBUS_BLOCK__PERIOD}, "Block polling period must be positive and greater than zero", new Object[0]);
                }
                if (block.getTimeout() < 0L) {
                    ctx.add(Severity.ERROR, new Object[]{block, ModbusPackage.Literals.MODBUS_BLOCK__TIMEOUT}, "Block timeout must not be negative", new Object[0]);
                }
                if (block.getStartAddress() < 0 || block.getStartAddress() >= 65536) {
                    ctx.add(Severity.ERROR, new Object[]{block, ModbusPackage.Literals.MODBUS_BLOCK__START_ADDRESS}, "Block address must be between {0} and {1}", new Object[]{0, 65536});
                }
                if (block.getStartAddress() + block.getCount() >= 65536) {
                    ctx.add(Severity.ERROR, new Object[]{block}, "A start address of {0} and block size of {1} would read beyond the maximum.", new Object[]{block.getStartAddress(), block.getCount()});
                }
                int typeLen = TypeHelper.calculateByteSize((TypeDefinition)block.getType());
                if (block.getCount() * 2 < typeLen) {
                    ctx.add(Severity.ERROR, new Object[]{block}, "The defined block type ({0} bytes) is bigger than the block request ({1} bytes / {2} registers).", new Object[]{typeLen, block.getCount() * 2, block.getCount()});
                }
                this.validateTypeSystem(device.getTypeSystem(), block, device, ctx);
            }
        }
    }

    private void validateTypeSystem(TypeSystem typeSystem, ModbusBlock block, ModbusDevice device, ValidationContext ctx) {
        if (!TypeHelper.hasType((TypeSystem)typeSystem, (TypeDefinition)block.getType())) {
            ctx.add(Severity.ERROR, new Object[]{block, ModbusPackage.Literals.MODBUS_BLOCK__TYPE}, "Block type {0} is not define in the type system of the device {1}", new Object[]{block.getId(), device.getName()});
        }
    }
}

