/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib;

import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.utils.ModelWriter;
import org.eclipse.scada.configuration.world.Driver;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.lib.NodeElementProcessor;
import org.eclipse.scada.da.server.exporter.ConfigurationType;
import org.eclipse.scada.da.server.exporter.DocumentRoot;
import org.eclipse.scada.da.server.exporter.ExportType;
import org.eclipse.scada.da.server.exporter.ExporterFactory;
import org.eclipse.scada.da.server.exporter.HiveConfigurationType;
import org.eclipse.scada.da.server.exporter.HiveType;

public abstract class DriverProcessor
implements NodeElementProcessor {
    private final Driver driver;

    public DriverProcessor(Driver driver) {
        this.driver = driver;
    }

    @Override
    public void process(String phase, IFolder baseDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        if (phase != null && !"process".equals(phase)) {
            return;
        }
        String name = this.makeName();
        IFolder output = baseDir.getFolder((IPath)new Path(name));
        output.create(true, true, null);
        IFile exporterFile = output.getFile("exporter.xml");
        IFile propFile = output.getFile("application.properties");
        DocumentRoot root = ExporterFactory.eINSTANCE.createDocumentRoot();
        ConfigurationType cfg = ExporterFactory.eINSTANCE.createConfigurationType();
        root.setConfiguration(cfg);
        HiveType hive = ExporterFactory.eINSTANCE.createHiveType();
        cfg.getHive().add((Object)hive);
        hive.setRef(this.getHiveId());
        HiveConfigurationType hiveCfg = ExporterFactory.eINSTANCE.createHiveConfigurationType();
        hive.setConfiguration(hiveCfg);
        this.addConfiguration(hiveCfg);
        for (Endpoint ep : this.driver.getEndpoints()) {
            this.addEndpoint(hive, ep);
        }
        new ModelWriter((EObject)root).store(URI.createPlatformResourceURI((String)exporterFile.getFullPath().toString(), (boolean)true));
        exporterFile.refreshLocal(1, monitor);
        if (propFile.exists()) {
            propFile.delete(true, monitor);
        }
        Properties p = new Properties();
        this.fillProperties(p);
        if (!p.isEmpty()) {
            Object object = null;
            Object var15_16 = null;
            try (FileOutputStream fos = new FileOutputStream(propFile.getRawLocation().toOSString());){
                p.store(fos, "Created by the Eclipse SCADA world generator");
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            propFile.refreshLocal(1, monitor);
        }
    }

    protected void fillProperties(Properties p) {
    }

    private void addEndpoint(HiveType hive, Endpoint ep) {
        ExportType exporter = ExporterFactory.eINSTANCE.createExportType();
        hive.getExport().add((Object)exporter);
        exporter.setUri(String.format("da:ngp://0.0.0.0:%s", ep.getPortNumber()));
    }

    protected abstract void addConfiguration(HiveConfigurationType var1);

    protected abstract String getHiveId();

    private String makeName() {
        return this.driver.getName();
    }
}

