/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.debian;

import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.world.lib.deployment.CommonPackageDeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;
import org.eclipse.scada.utils.pkg.deb.DebianPackageWriter;
import org.eclipse.scada.utils.pkg.deb.EntryInformation;

public class DebianDeploymentContext
extends CommonPackageDeploymentContext {
    private final Map<String, EntryInformation> tempFilesOptions = new HashMap<String, EntryInformation>();
    private final Map<String, File> tempFiles = new HashMap<String, File>();

    public DebianDeploymentContext(String packageName) {
        super(packageName);
    }

    @Override
    public void runAfterInstallation(String script) {
        this.postInstallation.append('\n');
        this.postInstallation.append("if test \"$1\" = configure ; then\n");
        this.postInstallation.append(script);
        this.postInstallation.append("\nfi\n");
    }

    @Override
    public void runAfterRemoval(String script) {
        this.postRemoval.append('\n');
        this.postRemoval.append("case \"$1\" in\n");
        this.postRemoval.append("\tremove|purge)\n");
        this.postRemoval.append(script);
        this.postRemoval.append("\n\t;;\n");
        this.postRemoval.append("\nesac\n");
    }

    public void scoopFiles(DebianPackageWriter deb) throws IOException {
        for (Map.Entry<String, File> entry : this.tempFiles.entrySet()) {
            deb.addFile(entry.getValue(), entry.getKey(), this.tempFilesOptions.get(entry.getKey()));
        }
        this.deleteTempFiles();
    }

    protected void deleteTempFiles() {
        for (Map.Entry<String, File> entry : this.tempFiles.entrySet()) {
            entry.getValue().delete();
        }
    }

    @Override
    public void addDirectory(String targetDirectory, FileInformation fileInformation) {
    }

    @Override
    public void addFile(ContentProvider content, String targetFile, FileInformation fileInformation) throws IOException {
        Throwable throwable = null;
        Object var5_7 = null;
        try (InputStream resource = content.createInputStream();){
            File tmp = Files.createTempFile("data", "", new FileAttribute[0]).toFile();
            File old = this.tempFiles.put(targetFile, tmp);
            if (old != null) {
                old.delete();
            }
            Throwable throwable2 = null;
            Object var10_16 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));){
                ByteStreams.copy((InputStream)resource, (OutputStream)os);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        if (fileInformation != null) {
            boolean conf = false;
            FileOptions[] fileOptionsArray = fileInformation.getOptions();
            int n = fileOptionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileOptions option = fileOptionsArray[n2];
                switch (option) {
                    case CONFIGURATION: {
                        conf = true;
                    }
                }
                ++n2;
            }
            EntryInformation ei = new EntryInformation(fileInformation.getOwner(), fileInformation.getGroup(), fileInformation.getMode().intValue(), conf);
            this.tempFilesOptions.put(targetFile, ei);
        }
    }
}

