/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.startup;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.world.lib.deployment.Contents;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.startup.StartupHandler;

public class LSBSystemVHandler
implements StartupHandler {
    private static Pattern ALT_PATTERN = Pattern.compile("\\@\\@(.*?)\\@\\@");

    @Override
    public void createDriver(DeploymentContext context, String driverName, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        context.addFile(Contents.createContent(LSBSystemVHandler.class.getResourceAsStream("templates/lsb_sysv/driver.service.sh"), replacements, ALT_PATTERN), "/etc/init.d/scada.driver." + driverName, new FileInformation(493));
    }

    @Override
    public void createEquinox(DeploymentContext context, String appName, Map<String, String> replacements, IProgressMonitor monitor) throws Exception {
        context.addFile(Contents.createContent(LSBSystemVHandler.class.getResourceAsStream("templates/lsb_sysv/p2.service.sh"), replacements, ALT_PATTERN), "/etc/init.d/scada.app." + appName, new FileInformation(493));
        context.addFile(Contents.createContent(LSBSystemVHandler.class.getResourceAsStream("templates/redhat_sysv/p2.launcher.sh"), replacements, ALT_PATTERN), "/usr/bin/scada.app." + appName + ".launcher", new FileInformation(493));
    }

    @Override
    public String startDriverCommand(String driverName) {
        return "/etc/init.d/scada.driver." + driverName + " start";
    }

    @Override
    public String stopDriverCommand(String driverName) {
        return "/etc/init.d/scada.driver." + driverName + " stop";
    }

    @Override
    public String startEquinoxCommand(String appName) {
        return "/etc/init.d/scada.app." + appName + " start";
    }

    @Override
    public String stopEquinoxCommand(String appName) {
        return "/etc/init.d/scada.app." + appName + " stop";
    }

    @Override
    public Set<String> getAdditionalPackageDependencies() {
        return Collections.singleton("screen");
    }
}

