/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.BufferedValue;
import org.eclipse.scada.configuration.world.osgi.MasterServer;

public class BufferProcessor
extends BasicOscarProcessor {
    private final MasterServer app;

    public BufferProcessor(MasterServer app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        for (BufferedValue bufferedValue : this.app.getBufferedValues()) {
            this.addBufferedValue(bufferedValue);
        }
    }

    private void addBufferedValue(BufferedValue bufferedValue) {
        String id = Names.makeName((NamedDocumentable)bufferedValue);
        HashMap<String, String> data = new HashMap<String, String>();
        if (bufferedValue.getItem() != null) {
            data.put("datasource.id", Items.makeMasterId(bufferedValue.getItem().getItem()));
        }
        if (bufferedValue.getInitialValue() != null) {
            data.put("initialValue", bufferedValue.getInitialValue().toString());
        }
        data.put("trigger", "" + bufferedValue.getTrigger());
        data.put("range", "" + bufferedValue.getRange());
        data.put("triggerOnly", "" + bufferedValue.getTriggerOnly());
        data.put("persistence", bufferedValue.getPersistence().getLiteral());
        this.addData("org.eclipse.scada.da.buffer", id, data);
    }
}

