/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Map;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.core.VariantType;

public final class Helper {
    private Helper() {
    }

    public static void addOptional(Map<String, String> data, String key, String value) {
        if (value != null && !value.isEmpty()) {
            data.put(key, value);
        }
    }

    public static void addOptional(Map<String, String> data, String key, Integer value) {
        if (value != null) {
            data.put(key, value.toString());
        }
    }

    public static VariantType convert(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        switch (dataType) {
            case BOOLEAN: {
                return VariantType.BOOLEAN;
            }
            case FLOAT: {
                return VariantType.DOUBLE;
            }
            case INT32: {
                return VariantType.INT32;
            }
            case INT64: {
                return VariantType.INT64;
            }
            case NULL: {
                return VariantType.NULL;
            }
            case STRING: {
                return VariantType.STRING;
            }
            case VARIANT: {
                return null;
            }
        }
        throw new IllegalStateException(String.format("The data type %s is unknown", dataType));
    }
}

