/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.Configurations;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MarkerEntry;
import org.eclipse.scada.configuration.world.osgi.MarkerGroup;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.utils.str.StringHelper;

public class MarkerGroupProcessor
extends BasicOscarProcessor {
    private final MasterServer app;
    private final MasterHandlerPriorities priorities;

    public MarkerGroupProcessor(MasterServer app, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
        this.priorities = priorities;
    }

    public void process() {
        if (this.app.getMarkers() == null) {
            return;
        }
        for (MarkerGroup group : this.app.getMarkers().getMarkerGroups()) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            this.addMarker(group.getName(), (Collection<Item>)group.getItems(), (Collection<MarkerEntry>)group.getMarkers(), attributes);
        }
    }

    private void addMarker(String id, Collection<Item> items, Collection<MarkerEntry> entries, Map<String, String> attributes) {
        HashMap<String, String> data = new HashMap<String, String>();
        int priority = this.priorities.findPriority("org.eclipse.scada.da.master.common.marker", id);
        data.put("handlerPriority", "" + priority);
        TreeSet<String> masterIds = new TreeSet<String>();
        for (Item item : items) {
            masterIds.add(Items.makeMasterId(item));
        }
        data.put("master.id", StringHelper.join(masterIds, (String)", "));
        data.put("exportAttribute", "true");
        data.put("alwaysExport", "true");
        for (MarkerEntry entry : entries) {
            data.put("marker." + entry.getName(), entry.getValue() == null ? "" : entry.getValue());
        }
        Configurations.applyInfoAttributes(attributes, data);
        this.addData("org.eclipse.scada.da.master.common.marker", id, data);
    }
}

