/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.configuration.world.HandlerPriorityRule;
import org.eclipse.scada.configuration.world.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterHandlerPriorities {
    private static final Logger logger = LoggerFactory.getLogger(MasterHandlerPriorities.class);
    private static final String DEFAULT_RULES_URI = System.getProperty("org.eclipse.scada.configurator.generator.world.defaultMasterHandlerPrioritiesUri", "platform:/plugin/org.eclipse.scada.configuration.lib/model/defaultPriorities.eswm");
    private final List<HandlerPriorityRule> rules;

    public MasterHandlerPriorities(World world) {
        if (world != null && world.getOptions() != null && world.getOptions().getMasterHandlerPriorities() != null) {
            logger.info("Using master handler priority rules from model: {}", (Object)world.getOptions().getMasterHandlerPriorities());
            this.rules = MasterHandlerPriorities.makeRules(world.getOptions().getMasterHandlerPriorities());
        } else {
            logger.info("Using default master handler priority rules from {}", (Object)DEFAULT_RULES_URI);
            this.rules = MasterHandlerPriorities.makeRules(MasterHandlerPriorities.loadDefaultRules());
        }
    }

    private static List<HandlerPriorityRule> makeRules(org.eclipse.scada.configuration.world.MasterHandlerPriorities masterHandlerPriorities) {
        if (masterHandlerPriorities == null) {
            return Collections.emptyList();
        }
        logger.debug("Set has {} rules", (Object)masterHandlerPriorities.getRules().size());
        logger.debug("Name: {}", (Object)masterHandlerPriorities.getName());
        logger.debug("IsProxy: {}", (Object)masterHandlerPriorities.eIsProxy());
        logger.debug("Rules: {}", (Object)masterHandlerPriorities.getRules());
        ArrayList<HandlerPriorityRule> result = new ArrayList<HandlerPriorityRule>((Collection<HandlerPriorityRule>)masterHandlerPriorities.getRules());
        Collections.sort(result, new Comparator<HandlerPriorityRule>(){

            @Override
            public int compare(HandlerPriorityRule o1, HandlerPriorityRule o2) {
                Integer i1 = o1.getOrder();
                Integer i2 = o2.getOrder();
                return i1.compareTo(i2);
            }
        });
        return result;
    }

    private static org.eclipse.scada.configuration.world.MasterHandlerPriorities loadDefaultRules() {
        try {
            return (org.eclipse.scada.configuration.world.MasterHandlerPriorities)new ModelLoader(org.eclipse.scada.configuration.world.MasterHandlerPriorities.class).load(URI.createURI((String)DEFAULT_RULES_URI));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int findPriority(String factoryId, String configurationId) {
        Integer result = this.findPriority(factoryId, configurationId, null);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException(String.format("Unable to find master handler priority for %s/%s", factoryId, configurationId));
    }

    public Integer findPriority(String factoryId, String configurationId, Integer defaultValue) {
        logger.trace("{} / {} - {} rules", new Object[]{factoryId, configurationId, this.rules.size()});
        for (HandlerPriorityRule rule : this.rules) {
            logger.trace("  -> {} - {}", (Object)rule.getFactoryId(), (Object)rule.getConfigurationFilter());
            if (rule.getFactoryId() != null && !rule.getFactoryId().equals(factoryId) || rule.getConfigurationFilter() != null && !rule.getConfigurationFilter().matcher(configurationId).matches()) continue;
            return rule.getPriority();
        }
        return defaultValue;
    }
}

