/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.sec;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.security.Rule;
import org.eclipse.scada.configuration.security.Script;
import org.eclipse.scada.configuration.security.ScriptRule;
import org.eclipse.scada.configuration.security.SignatureRule;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.sec.ScriptRuleEncoder;
import org.eclipse.scada.configuration.world.lib.oscar.sec.SigatureRuleEncoder;

public class RuleEncoder {
    public static final String ID = "org.eclipse.scada.sec.osgi.manager";
    private final Rule rule;

    public static RuleEncoder findEncoder(Rule rule) {
        if (rule instanceof ScriptRule) {
            return new ScriptRuleEncoder((ScriptRule)rule);
        }
        if (rule instanceof SignatureRule) {
            return new SigatureRuleEncoder((SignatureRule)rule);
        }
        return new RuleEncoder(rule);
    }

    public RuleEncoder(Rule rule) {
        this.rule = rule;
    }

    public void encodeRule(OscarContext target, int priority) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("serviceType", this.rule.getRuleType());
        data.put("priority", "" + priority);
        if (this.rule.getIdFilter() != null) {
            data.put("for.id", "" + this.rule.getIdFilter());
        }
        if (this.rule.getTypeFilter() != null) {
            data.put("for.type", "" + this.rule.getTypeFilter());
        }
        if (this.rule.getActionFilter() != null) {
            data.put("for.action", "" + this.rule.getActionFilter());
        }
        RuleEncoder.putScript(data, "filter.script", this.rule.getFilterScript());
        this.putData(data);
        target.addData(ID, this.rule.getId(), data);
    }

    protected void putData(Map<String, String> data) {
    }

    public static void putScript(Map<String, String> data, String prefix, Script script) {
        if (script == null) {
            return;
        }
        if (script.getSource() == null) {
            throw new NullPointerException("'script' must not be null");
        }
        data.put(prefix, script.getSource());
        if (script.getType() != null) {
            data.put(String.valueOf(prefix) + ".engine", script.getType());
        }
    }
}

