/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.infrastructure.ApplicationConfiguration;
import org.eclipse.scada.configuration.infrastructure.EquinoxApplication;
import org.eclipse.scada.configuration.infrastructure.HttpServiceModule;
import org.eclipse.scada.configuration.infrastructure.Module;

public final class HttpServices {
    private HttpServices() {
    }

    public static Set<HttpServiceModule> extract(Collection<? extends Module> elements) {
        HashSet<HttpServiceModule> result = new HashSet<HttpServiceModule>();
        for (Module module : elements) {
            if (!(module instanceof HttpServiceModule)) continue;
            result.add((HttpServiceModule)module);
        }
        return result;
    }

    public static boolean isValid(Object container, HttpServiceModule hsm) {
        return HttpServices.findLocal(container).contains(hsm);
    }

    public static Set<HttpServiceModule> findLocal(Object o) {
        if (!(o instanceof EObject)) {
            return Collections.emptySet();
        }
        EObject c = ((EObject)o).eContainer();
        if (c == null) {
            return Collections.emptySet();
        }
        HashSet<HttpServiceModule> result = new HashSet<HttpServiceModule>();
        if (c instanceof EquinoxApplication) {
            result.addAll(HttpServices.extract(((EquinoxApplication)c).getModules()));
            ApplicationConfiguration cfg = ((EquinoxApplication)c).getConfiguration();
            if (cfg != null) {
                result.addAll(HttpServices.extract(cfg.getModules()));
            }
        } else if (c instanceof ApplicationConfiguration) {
            result.addAll(HttpServices.extract(((ApplicationConfiguration)c).getModules()));
        }
        return result;
    }
}

