/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.dave.lib;

import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.dave.DaveCommunicationProcessor;
import org.eclipse.scada.configuration.dave.DaveDriver;
import org.eclipse.scada.configuration.dave.DaveRequestBlock;
import org.eclipse.scada.configuration.world.lib.oscar.EquinoxApplicationProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;

public class DaveDriverProcessor
extends EquinoxApplicationProcessor {
    private final DaveDriver driver;

    public DaveDriverProcessor(DaveDriver driver) {
        super((EquinoxApplication)driver);
        this.driver = driver;
    }

    protected void processForContext(OscarContext ctx, IFolder output, IProgressMonitor monitor) throws Exception {
        for (DaveCommunicationProcessor device : this.driver.getDevices()) {
            this.createDevice(ctx, device);
        }
    }

    private void createDevice(OscarContext ctx, DaveCommunicationProcessor device) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = device.getId();
        data.put("host", device.getEndpoint().getNode().getHostName());
        data.put("port", "" + device.getEndpoint().getPortNumber());
        data.put("readTimeout", "" + device.getReadTimeout());
        data.put("rack", "" + device.getRack());
        data.put("slot", "" + device.getSlot());
        data.put("name", device.getId());
        ctx.addData("org.eclipse.scada.da.server.dave.device", id, data);
        for (DaveRequestBlock block : device.getBlocks()) {
            this.createSlave(ctx, device, block);
        }
    }

    private void createSlave(OscarContext ctx, DaveCommunicationProcessor device, DaveRequestBlock block) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = block.getId();
        data.put("daveDevice", device.getId());
        data.put("area", "" + block.getArea());
        data.put("count", "" + block.getLength());
        data.put("enableStatistics", "" + block.isEnableStatistics());
        data.put("start", "" + block.getOffset());
        data.put("name", block.getName());
        data.put("block", "" + block.getBlock());
        data.put("type", block.getType().getName());
        ctx.addData("org.eclipse.scada.da.server.dave.block", id, data);
    }
}

