/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.dave;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.protocol.dave.DaveMessage;

public class DaveReadResult
extends DaveMessage {
    private final Collection<Result> result;

    public DaveReadResult(Collection<Result> result) {
        this.result = new ArrayList<Result>(result);
    }

    public Collection<Result> getResult() {
        return Collections.unmodifiableCollection(this.result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Result: ");
        sb.append(this.result.size());
        sb.append("@");
        int i = 0;
        for (Result result : this.result) {
            sb.append("[");
            sb.append(String.valueOf(i) + ": ");
            sb.append(result);
            sb.append(" ");
            sb.append("]");
            ++i;
        }
        return sb.toString();
    }

    public static class Result {
        private final Short error;
        private final IoBuffer data;

        public Result(short error) {
            this.error = error;
            this.data = null;
        }

        public Result(IoBuffer data) {
            this.error = null;
            this.data = data;
        }

        public IoBuffer getData() {
            return this.data;
        }

        public boolean isError() {
            return this.error != null;
        }

        public Short getError() {
            return this.error;
        }

        public String toString() {
            return String.format(this.isError() ? "E:" + this.error : "D:" + this.data, new Object[0]);
        }
    }
}

