/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.model;

import java.util.concurrent.CompletionStage;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;

public interface WriteModel {
    public Action prepareCommand(Request<Boolean> var1);

    public Action prepareSetpointFloat(Request<Float> var1);

    public Action prepareSetpointScaled(Request<Short> var1);

    default public Runnable dispose() {
        return () -> {};
    }

    @FunctionalInterface
    public static interface Action {
        public CompletionStage<Void> execute();
    }

    public static class Request<T> {
        private final ASDUHeader header;
        private final InformationObjectAddress address;
        private final T value;
        private final byte type;
        private final boolean execute;

        public Request(ASDUHeader header, InformationObjectAddress address, T value, byte type, boolean execute) {
            this.header = header;
            this.address = address;
            this.value = value;
            this.type = type;
            this.execute = execute;
        }

        public ASDUHeader getHeader() {
            return this.header;
        }

        public InformationObjectAddress getAddress() {
            return this.address;
        }

        public T getValue() {
            return this.value;
        }

        public byte getType() {
            return this.type;
        }

        public boolean isExecute() {
            return this.execute;
        }

        public String toString() {
            return String.format("[Request - header: %s, address: %s, value: %s, type: %s, execute: %s]", this.header, this.address, this.value, this.type, this.execute);
        }
    }
}

