/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.client;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.apci.APDUDecoder;
import org.eclipse.neoscada.protocol.iec60870.apci.APDUEncoder;
import org.eclipse.neoscada.protocol.iec60870.apci.MessageChannel;
import org.eclipse.neoscada.protocol.iec60870.asdu.MessageManager;
import org.eclipse.neoscada.protocol.iec60870.client.ClientModule;
import org.eclipse.neoscada.protocol.iec60870.client.ConnectionStateListener;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private final ProtocolOptions options;
    private final MessageManager manager;
    private final Bootstrap bootstrap;
    private final ClientModule[] modules;
    private final SocketAddress address;
    private final ExecutorService executor;
    private SettableFuture<Void> connectFuture;
    private Channel channel;
    private final NioEventLoopGroup group;
    private final ConnectionStateListener listener;

    public Client(SocketAddress address, ConnectionStateListener listener, ProtocolOptions options, List<ClientModule> modules) {
        this.address = address;
        this.options = options;
        this.listener = listener;
        this.manager = new MessageManager(options);
        this.group = new NioEventLoopGroup();
        this.bootstrap = new Bootstrap();
        this.bootstrap.group((EventLoopGroup)this.group);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                Client.this.handleInitChannel(ch);
            }
        });
        this.modules = modules.toArray(new ClientModule[modules.size()]);
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("IEC60870Client/" + address));
        for (ClientModule module : modules) {
            module.initializeClient(this, this.manager);
        }
    }

    public synchronized ListenableFuture<Void> connect() {
        if (this.connectFuture != null) {
            return this.connectFuture;
        }
        ChannelFuture channelFuture = this.bootstrap.connect(this.address);
        this.connectFuture = SettableFuture.create();
        channelFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Client.this.handleOperationComplete((SettableFuture<Void>)Client.this.connectFuture, future);
            }
        });
        return this.connectFuture;
    }

    protected synchronized void handleOperationComplete(SettableFuture<Void> result, ChannelFuture future) {
        if (this.connectFuture != result) {
            return;
        }
        this.connectFuture = null;
        try {
            future.get();
            this.channel = future.channel();
            this.fireConnected(this.channel);
            result.set(null);
        }
        catch (InterruptedException | ExecutionException e) {
            this.fireDisconnected(e);
            result.setException((Throwable)e);
        }
    }

    private void fireConnected(final Channel channel) {
        if (this.listener != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Client.this.listener.connected(channel);
                }
            });
        }
    }

    private void fireDisconnected(final Exception e) {
        if (this.listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Client.this.listener.disconnected(e);
            }
        });
    }

    protected void handleInitChannel(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{new APDUDecoder()});
        ch.pipeline().addLast(new ChannelHandler[]{new APDUEncoder()});
        if (Boolean.getBoolean("org.eclipse.scada.protocol.iec60870.trace")) {
            ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
        }
        MessageChannel messageChannel = new MessageChannel(this.options, this.manager);
        ch.pipeline().addLast(new ChannelHandler[]{messageChannel});
        ClientModule[] clientModuleArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            ClientModule module = clientModuleArray[n2];
            module.initializeChannel(ch, messageChannel);
            ++n2;
        }
        ch.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                logger.warn("Close connection due to uncaught exception", cause);
                ctx.close();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                Client.this.fireDisconnected(null);
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Client client = this;
        synchronized (client) {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            ClientModule[] clientModuleArray = this.modules;
            int n = this.modules.length;
            int n2 = 0;
            while (n2 < n) {
                ClientModule module = clientModuleArray[n2];
                module.dispose();
                ++n2;
            }
        }
        logger.debug("Shutting down main group");
        Future f = this.group.shutdownGracefully();
        f.addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(){

            public void operationComplete(Future<Object> arg0) throws Exception {
                Client.this.disposeExecutor();
            }
        });
    }

    protected void disposeExecutor() {
        logger.debug("Shutting down executor");
        this.executor.shutdown();
    }

    public void writeCommand(Object command) {
        this.channel.writeAndFlush(command);
    }
}

