/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.relp.service;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import org.eclipse.scada.protocol.relp.service.ReceiverHandler;
import org.eclipse.scada.protocol.relp.service.ReceiverHandlerFactory;
import org.eclipse.scada.protocol.relp.service.ReceiverSession;
import org.eclipse.scada.protocol.syslog.Facility;
import org.eclipse.scada.protocol.syslog.Severity;
import org.eclipse.scada.protocol.syslog.SyslogMessage;

public class StreamHandlerFactory
implements ReceiverHandlerFactory {
    private final PrintWriter writer;

    public StreamHandlerFactory(OutputStream stream) {
        this.writer = new PrintWriter(stream, true);
    }

    protected void log(SyslogMessage msg) {
        this.writer.println(msg);
    }

    @Override
    public ReceiverHandler createHandler() {
        return new ReceiverHandler(){

            @Override
            public void opened(ReceiverSession session) {
                StreamHandlerFactory.this.log(new SyslogMessage(Facility.INTERNAL, Severity.NOTICE, Calendar.getInstance(), null, null, null, "Session opened"));
            }

            @Override
            public void message(ReceiverSession session, SyslogMessage message) {
                StreamHandlerFactory.this.log(message);
            }

            @Override
            public void closed(ReceiverSession session) {
                StreamHandlerFactory.this.log(new SyslogMessage(Facility.INTERNAL, Severity.NOTICE, Calendar.getInstance(), null, null, null, "Session closed"));
            }
        };
    }
}

