/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public abstract class AbstractMeasuredValueFloatingPoint
extends AbstractMessage {
    protected final List<InformationEntry<Float>> entries;
    private final boolean withTimestamp;

    public AbstractMeasuredValueFloatingPoint(ASDUHeader header, List<InformationEntry<Float>> entries, boolean withTimestamp) {
        super(header);
        this.entries = entries;
        this.withTimestamp = withTimestamp;
    }

    public List<InformationEntry<Float>> getEntries() {
        return this.entries;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.entries.size(), this.header, out);
        for (InformationEntry<Float> entry : this.entries) {
            entry.getAddress().encode(options, out);
            TypeHelper.encodeFloatValue(options, out, entry.getValue(), this.withTimestamp);
        }
    }

    protected static List<InformationEntry<Float>> parseEntries(ProtocolOptions options, byte length, ByteBuf data, boolean withTimestamp) {
        ArrayList<InformationEntry<Float>> values = new ArrayList<InformationEntry<Float>>(length);
        int i = 0;
        while (i < length) {
            InformationObjectAddress address = InformationObjectAddress.parse(options, data);
            Value<Float> value = TypeHelper.parseFloatValue(options, data, withTimestamp);
            values.add(new InformationEntry<Float>(address, value));
            ++i;
        }
        return values;
    }
}

