/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public abstract class AbstractSingleBooleanBaseSingle
extends AbstractMessage {
    private final List<InformationEntry<Boolean>> entries;
    private final boolean withTimestamp;

    public AbstractSingleBooleanBaseSingle(ASDUHeader header, List<InformationEntry<Boolean>> entries, boolean withTimestamp) {
        super(header);
        this.withTimestamp = withTimestamp;
        this.entries = entries;
    }

    public List<InformationEntry<Boolean>> getEntries() {
        return this.entries;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, this.entries.size(), this.header, out);
        for (InformationEntry<Boolean> entry : this.entries) {
            entry.getAddress().encode(options, out);
            TypeHelper.encodeBooleanValue(options, out, entry.getValue(), this.withTimestamp);
        }
    }

    protected static List<InformationEntry<Boolean>> parseEntries(ProtocolOptions options, byte length, ByteBuf data, boolean withTimestamp) {
        ArrayList<InformationEntry<Boolean>> values = new ArrayList<InformationEntry<Boolean>>(length);
        int i = 0;
        while (i < length) {
            InformationObjectAddress address = InformationObjectAddress.parse(options, data);
            Value<Boolean> value = TypeHelper.parseBooleanValue(options, data, withTimestamp);
            values.add(new InformationEntry<Boolean>(address, value));
            ++i;
        }
        return values;
    }
}

