/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractInformationObjectMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;

@ASDU(id=100, name="C_IC_NA_1")
public class InterrogationCommand
extends AbstractInformationObjectMessage {
    private final short qualifierOfInterrogation;

    public InterrogationCommand(ASDUHeader header, short qualifierOfInterrogation) {
        this(header, InformationObjectAddress.DEFAULT, qualifierOfInterrogation);
    }

    public InterrogationCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, short qualifierOfInterrogation) {
        super(header, informationObjectAddress);
        this.qualifierOfInterrogation = qualifierOfInterrogation;
    }

    public short getQualifierOfInterrogation() {
        return this.qualifierOfInterrogation;
    }

    public static InterrogationCommand parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress informationObjectAddress = InformationObjectAddress.parse(options, data);
        short qualifierOfInterrogation = data.readUnsignedByte();
        InterrogationCommand result = new InterrogationCommand(header, informationObjectAddress, qualifierOfInterrogation);
        return result;
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, null, this.header, out);
        this.informationObjectAddress.encode(options, out);
        out.writeByte((int)this.qualifierOfInterrogation);
    }

    public InterrogationCommand mirror(Cause cause) {
        return new InterrogationCommand(this.header.clone(cause), this.qualifierOfInterrogation);
    }
}

