/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractMeasuredValueScaled;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=11, name="M_ME_NB_1", informationStructure=InformationStructure.SINGLE)
public class MeasuredValueScaledSingle
extends AbstractMeasuredValueScaled {
    private MeasuredValueScaledSingle(ASDUHeader header, List<InformationEntry<Short>> entries) {
        super(header, entries, false);
    }

    public static MeasuredValueScaledSingle parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        return new MeasuredValueScaledSingle(header, MeasuredValueScaledSingle.parseEntries(options, length, data, false));
    }

    public static MeasuredValueScaledSingle create(ASDUHeader header, InformationObjectAddress address, Value<Short> value) {
        return MeasuredValueScaledSingle.createInternal(header, Collections.singletonList(new InformationEntry<Short>(address, value)));
    }

    public static MeasuredValueScaledSingle create(ASDUHeader header, List<InformationEntry<Short>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return MeasuredValueScaledSingle.createInternal(header, new ArrayList<InformationEntry<Short>>(values));
    }

    private static MeasuredValueScaledSingle createInternal(ASDUHeader header, List<InformationEntry<Short>> values) {
        return new MeasuredValueScaledSingle(header, values);
    }
}

