/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractInformationObjectMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MirrorableMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;

@ASDU(id=49, name="C_SE_NB_1", informationStructure=InformationStructure.SINGLE)
public class SetPointCommandScaledValue
extends AbstractInformationObjectMessage
implements MirrorableMessage<SetPointCommandScaledValue> {
    private final byte type;
    private final boolean execute;
    private final short value;

    public SetPointCommandScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, short value, byte type, boolean execute) {
        super(header, informationObjectAddress);
        this.value = value;
        this.type = type;
        this.execute = execute;
    }

    public SetPointCommandScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, short value) {
        this(header, informationObjectAddress, value, 0, true);
    }

    public byte getType() {
        return this.type;
    }

    public short getValue() {
        return this.value;
    }

    public boolean isExecute() {
        return this.execute;
    }

    @Override
    public SetPointCommandScaledValue mirror(Cause cause, boolean positive) {
        return new SetPointCommandScaledValue(this.header.clone(cause, positive), this.informationObjectAddress, this.value, this.type, this.execute);
    }

    @Override
    public void encode(ProtocolOptions options, ByteBuf out) {
        EncodeHelper.encodeHeader(this, options, null, this.header, out);
        this.informationObjectAddress.encode(options, out);
        out.writeShort((int)this.value);
        int b = 0;
        b = (byte)(b | this.type & 0xFF);
        b = (byte)(b | (this.execute ? 0 : 256));
        out.writeByte(b);
    }

    public static SetPointCommandScaledValue parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress address = InformationObjectAddress.parse(options, data);
        short value = data.readShort();
        byte b = data.readByte();
        byte type = (byte)(b & 0xFF);
        boolean execute = (b & 0x100) <= 0;
        return new SetPointCommandScaledValue(header, address, value, type, execute);
    }
}

