/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;

public class InformationObjectAddress {
    public static final InformationObjectAddress DEFAULT = new InformationObjectAddress(0);
    private final int address;

    public static InformationObjectAddress valueOf(int address) {
        return new InformationObjectAddress(address);
    }

    public InformationObjectAddress(int address) {
        if (address < 0 || address > 0xFFFFFF) {
            throw new IllegalArgumentException(String.format("Address value must be between 0 and 0x00FFFFFF", new Object[0]));
        }
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    public void encode(ProtocolOptions options, ByteBuf out) {
        options.getInformationObjectAddressType().write(this.address, out);
    }

    public InformationObjectAddress increment() {
        return this.increment(1);
    }

    public InformationObjectAddress increment(int count) {
        return new InformationObjectAddress(this.address + count);
    }

    public static InformationObjectAddress parse(ProtocolOptions options, ByteBuf data) {
        return new InformationObjectAddress(options.getInformationObjectAddressType().read(data));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.address;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InformationObjectAddress other = (InformationObjectAddress)obj;
        return this.address == other.address;
    }

    public String toString() {
        int[] add = this.toArray();
        return String.format("[%d-%d-%d # %d]", add[0], add[1], add[2], this.address);
    }

    public int[] toArray() {
        ByteBuf buf = Unpooled.buffer((int)4);
        buf.writeMedium(this.address);
        return new int[]{buf.getUnsignedByte(0), buf.getUnsignedByte(1), buf.getUnsignedByte(2)};
    }

    public static InformationObjectAddress fromArray(int[] data) {
        if (data.length > 3) {
            throw new IllegalArgumentException("Address may only have a maximum of 3 segments");
        }
        int address = 0;
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int seg = nArray[n2];
            address = address << 8 | seg;
            ++n2;
        }
        return InformationObjectAddress.valueOf(address);
    }

    public static InformationObjectAddress fromString(String value) {
        int address = 0;
        String[] stringArray = value.split("-");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            address = address << 8 | Integer.parseInt(tok);
            ++n2;
        }
        return InformationObjectAddress.valueOf(address);
    }
}

