/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.client.data;

import io.netty.channel.ChannelHandlerContext;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DataTransmissionMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DoublePointInformationTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.InterrogationCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueShortFloatingPointTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SinglePointInformationTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataHandler;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleContext;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions;
import org.eclipse.neoscada.protocol.iec60870.io.AbstractModuleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModuleHandler
extends AbstractModuleHandler
implements DataModuleContext {
    private static final Logger logger = LoggerFactory.getLogger(DataModuleHandler.class);
    private final DataHandler dataHandler;
    private final DataModuleOptions options;
    private ChannelHandlerContext ctx;

    public DataModuleHandler(DataHandler dataHandler, DataModuleOptions options) {
        this.dataHandler = dataHandler;
        this.options = options;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.ctx = ctx;
        this.dataHandler.activated(this, ctx);
    }

    protected ASDUHeader makeHeader(Cause cause, ASDUAddress address) {
        if (this.options.getCauseSourceAddress() != null) {
            return new ASDUHeader(new CauseOfTransmission(cause, this.options.getCauseSourceAddress()), address);
        }
        return new ASDUHeader(new CauseOfTransmission(cause), address);
    }

    @Override
    public void startInterrogation(ASDUAddress address, short qualifierOfInterrogation) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        ctx.writeAndFlush((Object)new InterrogationCommand(this.makeHeader((Cause)StandardCause.ACTIVATED, address), qualifierOfInterrogation));
    }

    @Override
    public void requestStartData() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        ctx.writeAndFlush((Object)DataTransmissionMessage.REQUEST_START);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        logger.trace("channelRead - ctx: {}, msg: {}", (Object)ctx, msg);
        if (msg == DataTransmissionMessage.CONFIRM_START) {
            this.handleStarted();
        } else if (msg instanceof SinglePointInformationTimeSingle) {
            this.handleDataMessage((SinglePointInformationTimeSingle)msg);
        } else if (msg instanceof SinglePointInformationSingle) {
            this.handleDataMessage((SinglePointInformationSingle)msg);
        } else if (msg instanceof SinglePointInformationSequence) {
            this.handleDataMessage((SinglePointInformationSequence)msg);
        } else if (msg instanceof DoublePointInformationTimeSingle) {
            this.handleDataMessage((DoublePointInformationTimeSingle)msg);
        } else if (msg instanceof DoublePointInformationSingle) {
            this.handleDataMessage((DoublePointInformationSingle)msg);
        } else if (msg instanceof DoublePointInformationSequence) {
            this.handleDataMessage((DoublePointInformationSequence)msg);
        } else if (msg instanceof MeasuredValueShortFloatingPointTimeSingle) {
            this.handleDataMessage((MeasuredValueShortFloatingPointTimeSingle)msg);
        } else if (msg instanceof MeasuredValueShortFloatingPointSingle) {
            this.handleDataMessage((MeasuredValueShortFloatingPointSingle)msg);
        } else if (msg instanceof MeasuredValueShortFloatingPointSequence) {
            this.handleDataMessage((MeasuredValueShortFloatingPointSequence)msg);
        } else if (msg instanceof MeasuredValueScaledTimeSingle) {
            this.handleDataMessage((MeasuredValueScaledTimeSingle)msg);
        } else if (msg instanceof MeasuredValueScaledSingle) {
            this.handleDataMessage((MeasuredValueScaledSingle)msg);
        } else if (msg instanceof MeasuredValueScaledSequence) {
            this.handleDataMessage((MeasuredValueScaledSequence)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.handleDisconnected();
        super.channelInactive(ctx);
    }

    protected void handleDisconnected() {
        this.dataHandler.disconnected();
    }

    protected void handleStarted() {
        this.dataHandler.started();
    }

    protected void handleDataMessage(SinglePointInformationTimeSingle msg) {
        if (this.ignoreMessage(msg)) {
            return;
        }
        this.dataHandler.process(msg);
    }

    protected boolean ignoreMessage(SinglePointInformationTimeSingle msg) {
        Cause cause = msg.getHeader().getCauseOfTransmission().getCause();
        return cause == StandardCause.BACKGROUND && this.options.isIgnoreBackgroundScan();
    }

    protected void handleDataMessage(SinglePointInformationSequence msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(SinglePointInformationSingle msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(DoublePointInformationSequence msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(DoublePointInformationSingle msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(DoublePointInformationTimeSingle msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(MeasuredValueShortFloatingPointTimeSingle msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(MeasuredValueShortFloatingPointSingle msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(MeasuredValueShortFloatingPointSequence msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(MeasuredValueScaledSequence msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(MeasuredValueScaledSingle msg) {
        this.dataHandler.process(msg);
    }

    protected void handleDataMessage(MeasuredValueScaledTimeSingle msg) {
        this.dataHandler.process(msg);
    }
}

