/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.apci;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.apci.APCIBase;
import org.eclipse.neoscada.protocol.iec60870.apci.InformationTransfer;
import org.eclipse.neoscada.protocol.iec60870.apci.Supervisory;
import org.eclipse.neoscada.protocol.iec60870.apci.UnnumberedControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APDUDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(APDUDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("decode - bytes: {}", (Object)ByteBufUtil.hexDump((ByteBuf)in));
        }
        if (in.readableBytes() < 6) {
            return;
        }
        byte start = in.getByte(in.readerIndex() + 0);
        if (start != 104) {
            throw new DecoderException(String.format("ACPI must start with 0x%02x but did with 0x%02x", (byte)104, start));
        }
        short len = in.getUnsignedByte(in.readerIndex() + 1);
        if (len > 253) {
            throw new DecoderException(String.format("APCI has a maximum length of %s bytes, but we received %s", (short)253, len));
        }
        if (in.readableBytes() < len + 2) {
            return;
        }
        in.skipBytes(2);
        ByteBuf controlFields = in.readSlice(4);
        ByteBuf data = len > 4 ? Unpooled.copiedBuffer((ByteBuf)in.readSlice(len - 4)).order(ByteOrder.LITTLE_ENDIAN) : null;
        out.add(this.decode(controlFields, data));
    }

    private APCIBase decode(ByteBuf controlFields, ByteBuf data) {
        logger.trace("Control Fields: {}", (Object)ByteBufUtil.hexDump((ByteBuf)controlFields));
        controlFields = controlFields.order(ByteOrder.LITTLE_ENDIAN);
        byte first = controlFields.getByte(0);
        if ((first & 1) == 0) {
            int sendSequenceNumber = controlFields.readUnsignedShort() >> 1;
            int receiveSequenceNumber = controlFields.readUnsignedShort() >> 1;
            logger.debug("S: {}, R: {}", (Object)sendSequenceNumber, (Object)receiveSequenceNumber);
            return new InformationTransfer(sendSequenceNumber, receiveSequenceNumber, data);
        }
        if ((first & 3) == 1) {
            controlFields.skipBytes(2);
            int receiveSequenceNumber = controlFields.readUnsignedShort() >> 1;
            return new Supervisory(receiveSequenceNumber);
        }
        if ((first & 3) == 3) {
            UnnumberedControl.Function function = this.convertFunction(controlFields.readUnsignedByte());
            return new UnnumberedControl(function);
        }
        throw new DecoderException("Invalid control fields");
    }

    private UnnumberedControl.Function convertFunction(int functions) {
        switch (functions) {
            case 7: {
                return UnnumberedControl.Function.STARTDT_ACT;
            }
            case 11: {
                return UnnumberedControl.Function.STARTDT_CONFIRM;
            }
            case 19: {
                return UnnumberedControl.Function.STOPDT_ACT;
            }
            case 35: {
                return UnnumberedControl.Function.STOPDT_CONFIRM;
            }
            case 67: {
                return UnnumberedControl.Function.TESTFR_ACT;
            }
            case 131: {
                return UnnumberedControl.Function.TESTFR_CONFIRM;
            }
        }
        throw new DecoderException(String.format("Invalid function codes for U-format (%02x)", functions));
    }
}

