/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu;

import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;

public class ASDUHeader {
    private final CauseOfTransmission causeOfTransmission;
    private final ASDUAddress asduAddress;

    public ASDUHeader(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress) {
        this.causeOfTransmission = causeOfTransmission;
        this.asduAddress = asduAddress;
    }

    public CauseOfTransmission getCauseOfTransmission() {
        return this.causeOfTransmission;
    }

    public ASDUAddress getAsduAddress() {
        return this.asduAddress;
    }

    public String toString() {
        return String.format("[cause: %s, address: %s]", this.causeOfTransmission, this.asduAddress);
    }

    public ASDUHeader clone(CauseOfTransmission causeOfTransmission) {
        return new ASDUHeader(causeOfTransmission, this.asduAddress);
    }

    public ASDUHeader clone(Cause cause) {
        return new ASDUHeader(new CauseOfTransmission(cause, this.causeOfTransmission.getSourceAddress()), this.asduAddress);
    }

    public ASDUHeader clone(Cause cause, boolean positive) {
        return new ASDUHeader(new CauseOfTransmission(cause, this.causeOfTransmission.getSourceAddress(), positive, false), this.asduAddress);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.asduAddress == null ? 0 : this.asduAddress.hashCode());
        result = 31 * result + (this.causeOfTransmission == null ? 0 : this.causeOfTransmission.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASDUHeader other = (ASDUHeader)obj;
        if (this.asduAddress == null ? other.asduAddress != null : !this.asduAddress.equals(other.asduAddress)) {
            return false;
        }
        return !(this.causeOfTransmission == null ? other.causeOfTransmission != null : !this.causeOfTransmission.equals(other.causeOfTransmission));
    }
}

