/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.codec;

import java.nio.ByteOrder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.eclipse.scada.protocol.common.Checksum;
import org.eclipse.scada.protocol.modbus.message.Pdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusRtuEncoder
extends ProtocolEncoderAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ModbusRtuEncoder.class);

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        logger.debug("Encoding: {}", message);
        Pdu request = (Pdu)message;
        IoBuffer buffer = IoBuffer.allocate((int)(request.getData().remaining() + 3));
        buffer.setAutoExpand(true);
        IoBuffer pdu = request.getData();
        buffer.put(request.getUnitIdentifier());
        buffer.put(pdu);
        int crc = Checksum.crc16((byte[])buffer.array(), (int)0, (int)(pdu.limit() + 1));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort((short)crc);
        buffer.flip();
        logger.trace("Encoded to: {}", (Object)buffer);
        out.write((Object)buffer);
    }
}

