/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common;

import java.io.File;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.mina.filter.ssl.KeyStoreFactory;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslHelper {
    private static final Logger logger = LoggerFactory.getLogger(SslHelper.class);

    private SslHelper() {
    }

    protected static String get(Map<String, String> properties, String key, String defaultValue) {
        String value = properties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean isSslRequired(Map<String, String> properties) {
        return properties.containsKey("requireSsl") && properties.get("requireSsl") != null && Boolean.parseBoolean(properties.get("requireSsl"));
    }

    public static SslContextFactory createDefaultSslFactory(Map<String, String> properties, boolean clientMode) throws Exception {
        File keyStoreFile;
        boolean requireSsl = SslHelper.isSslRequired(properties);
        File defaultKeyStoreFile = SslHelper.findDefaultKeyStore();
        String keyStoreFileName = SslHelper.get(properties, "sslKeyStoreFile", null);
        File file = keyStoreFile = keyStoreFileName != null ? new File(keyStoreFileName) : null;
        if (keyStoreFile == null && defaultKeyStoreFile == null && !requireSsl) {
            return null;
        }
        if (keyStoreFile == null && defaultKeyStoreFile != null) {
            logger.debug("Using default key store file: {}", (Object)defaultKeyStoreFile);
            keyStoreFile = defaultKeyStoreFile;
        }
        if (keyStoreFile == null) {
            return null;
        }
        String trustStoreFile = SslHelper.get(properties, "sslTrustStoreFile", keyStoreFile.getAbsolutePath());
        String password = SslHelper.get(properties, "sslPassword", null);
        String keyStorePassword = SslHelper.get(properties, "sslKeyStorePassword", password);
        String trustStorePassword = SslHelper.get(properties, "sslTrustStorePassword", keyStorePassword);
        String keyPassword = SslHelper.get(properties, "sslKeyPassword", keyStorePassword);
        if (!(keyStorePassword != null && trustStorePassword != null && keyPassword != null || requireSsl)) {
            return null;
        }
        SslContextFactory factory = new SslContextFactory();
        logger.debug("Default KeyStore: {}", (Object)KeyStore.getDefaultType());
        logger.debug("Default KeyManagerFactory: {}", (Object)KeyManagerFactory.getDefaultAlgorithm());
        logger.debug("Default TrustManagerFactory: {}", (Object)TrustManagerFactory.getDefaultAlgorithm());
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        keyStoreFactory.setDataFile(keyStoreFile);
        keyStoreFactory.setPassword(keyStorePassword);
        KeyStoreFactory trustStoreFactory = new KeyStoreFactory();
        trustStoreFactory.setDataFile(new File(trustStoreFile));
        trustStoreFactory.setPassword(trustStorePassword);
        factory.setKeyManagerFactoryKeyStore(keyStoreFactory.newInstance());
        factory.setTrustManagerFactoryKeyStore(trustStoreFactory.newInstance());
        factory.setKeyManagerFactoryKeyStorePassword(keyPassword);
        return factory;
    }

    private static File findDefaultKeyStore() {
        File file = SslHelper.testKeyStore(String.valueOf(System.getProperty("user.home")) + "/.eclipseScada/keystore");
        if (file != null) {
            return file;
        }
        file = SslHelper.testKeyStore(String.valueOf(System.getProperty("user.home")) + "/.eclipse.scada/keystore");
        if (file != null) {
            return file;
        }
        file = SslHelper.testKeyStore(String.valueOf(System.getProperty("java.home")) + "/lib/security/cacerts");
        if (file != null) {
            return file;
        }
        return null;
    }

    private static File testKeyStore(String name) {
        logger.debug("Testing: {}", (Object)name);
        if (name == null) {
            return null;
        }
        File file = new File(name);
        if (!file.canRead()) {
            return null;
        }
        logger.info("Considering: {}", (Object)name);
        return file;
    }
}

