/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.handshake;

import java.util.Map;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.eclipse.scada.protocol.ngp.common.mc.MessageChannelFilter;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.Handshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.HandshakeContext;
import org.eclipse.scada.protocol.ngp.common.mc.message.StartMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartSessionHandshake
implements Handshake {
    private static final Logger logger = LoggerFactory.getLogger(StartSessionHandshake.class);
    private static final String PROP_ENABLE = "startSession.enable";

    protected boolean isEnabled(Map<String, String> properties) {
        String value = properties.get(PROP_ENABLE);
        logger.debug("Property value: {}", (Object)value);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public void request(HandshakeContext context, Map<String, String> helloProperties) {
        logger.debug("Requesting enable");
        helloProperties.put(PROP_ENABLE, "true");
    }

    @Override
    public void handshake(HandshakeContext context, Map<String, String> helloProperties, Map<String, String> acceptedProperties) throws Exception {
        if (this.isEnabled(helloProperties)) {
            logger.debug("Enable session start handling");
            acceptedProperties.put(PROP_ENABLE, "true");
        }
    }

    @Override
    public void apply(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }

    @Override
    public void postApply(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
        if (this.isEnabled(acceptedProperties)) {
            if (context.isClientMode()) {
                logger.debug("Sending session start");
                context.getNextFilter().filterWrite(context.getSession(), (WriteRequest)new DefaultWriteRequest((Object)new StartMessage()));
            }
        } else if (!context.isClientMode()) {
            logger.debug("Marking session directly as opened since we are not enabled");
            MessageChannelFilter.markOpened(context.getSession());
        }
    }

    @Override
    public void sessionStarted(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }
}

