/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.SyntaxException;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.template.TemplateParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admingui.common.util.AppUtil;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class DeploymentHandler {
    private static final String MODULE_NAME_KEY = "module-name";
    private static final String DD_PATH_KEY = "dd-path";
    private static final String DD_CONTENT_KEY = "dd-content";

    public static void deploy(HandlerContext handlerCtx) {
        String appType = (String)handlerCtx.getInputValue("appType");
        String origPath = (String)handlerCtx.getInputValue("origPath");
        String filePath = (String)handlerCtx.getInputValue("filePath");
        Map allMaps = (Map)handlerCtx.getInputValue("allMaps");
        HashMap<String, String> attrMap = new HashMap<String, String>((Map)allMaps.get(appType));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        ArrayList<String> appRefs = new ArrayList<String>();
        if (GuiUtil.isEmpty(origPath)) {
            GuiUtil.getLogger().info("deploy(): origPath is NULL");
            String mesg = GuiUtil.getMessage("deployment.failure");
            GuiUtil.handleError(handlerCtx, mesg);
            return;
        }
        try {
            String decodedName = URLDecoder.decode((String)attrMap.get("name"), "UTF-8");
            attrMap.put("name", decodedName);
        }
        catch (Exception decodedName) {
            // empty catch block
        }
        String[] vs = (String[])attrMap.get("virtualservers");
        if (vs != null && vs.length > 0 && !GuiUtil.isEmpty(vs[0])) {
            String vsTargets = GuiUtil.arrayToString(vs, ",");
            payload.put("virtualservers", vsTargets);
        }
        attrMap.remove("virtualservers");
        List convertToFalseList = (List)attrMap.get("convertToFalseList");
        if (convertToFalseList != null) {
            for (String one : convertToFalseList) {
                if (attrMap.get(one) != null) continue;
                attrMap.put(one, "false");
            }
            attrMap.remove("convertToFalseList");
        }
        StringBuilder sb = new StringBuilder();
        String sep = "";
        Properties props = new Properties();
        for (Object attr : attrMap.keySet()) {
            String key = (String)attr;
            String prefix = "PROPERTY-";
            String value = (String)attrMap.get(key);
            if (value == null) continue;
            if (key.startsWith(prefix)) {
                if (value.equals("")) continue;
                props.setProperty(key.substring(prefix.length()), value);
                sb.append(sep).append(key.substring(prefix.length())).append("=").append(value);
                sep = ":";
                continue;
            }
            payload.put(key, value);
        }
        List propertyList = (List)handlerCtx.getInputValue("propertyList");
        if (propertyList != null) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Map oneRow : propertyList) {
                String name = (String)oneRow.get("name");
                if (GuiUtil.isEmpty(name)) continue;
                if (propertyNames.contains(name)) {
                    Logger logger = GuiUtil.getLogger();
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, GuiUtil.getCommonMessage("LOG_IGNORE_DUP_PROP", new Object[]{name}));
                    continue;
                }
                propertyNames.add(name);
                String value = (String)oneRow.get("value");
                if (GuiUtil.isEmpty(value)) continue;
                props.setProperty(name, value);
            }
        }
        if (sb.length() > 0) {
            payload.put("properties", sb.toString());
        }
        payload.put("id", filePath);
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        if (targets == null || targets.length == 0) {
            payload.put("target", "domain");
        } else {
            payload.put("target", targets[0]);
            for (int i = 1; i < targets.length; ++i) {
                appRefs.add(targets[i]);
            }
        }
        try {
            String prefix = (String)GuiUtil.getSessionValue("REST_URL");
            RestUtil.restRequest(prefix + "/applications/application", payload, "post", null, true);
            if (appRefs.size() > 0) {
                List clusters = TargetUtil.getClusters();
                List standalone = TargetUtil.getStandaloneInstances();
                for (int i = 0; i < appRefs.size(); ++i) {
                    AppUtil.manageAppTarget((String)attrMap.get("name"), (String)appRefs.get(i), true, (String)attrMap.get("enabled"), clusters, standalone, handlerCtx);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void redeploy(HandlerContext handlerCtx) {
        try {
            List targetList;
            String keepState;
            String filePath = (String)handlerCtx.getInputValue("filePath");
            Map deployMap = (Map)handlerCtx.getInputValue("deployMap");
            Map valueMap = (Map)handlerCtx.getInputValue("valueMap");
            List convertToFalsList = (List)handlerCtx.getInputValue("convertToFalse");
            if (convertToFalsList != null) {
                for (String one : convertToFalsList) {
                    if (deployMap.get(one) != null) continue;
                    deployMap.put(one, "false");
                }
            }
            String appName = (String)deployMap.get("appName");
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String ctxRoot = (String)valueMap.get("contextRoot");
            if (ctxRoot != null) {
                payload.put("contextroot", ctxRoot);
            }
            if ((keepState = (String)deployMap.get("keepState")) != null) {
                payload.put("keepstate", keepState);
            }
            payload.put("id", filePath);
            payload.put("force", "true");
            payload.put("name", appName);
            payload.put("deploymentOrder", deployMap.get("deploymentOrder"));
            payload.put("verify", deployMap.get("verify"));
            payload.put("precompilejsp", deployMap.get("precompilejsp"));
            payload.put("availabilityEnabled", deployMap.get("availabilityEnabled"));
            if ("osgi".equals(deployMap.get("type"))) {
                payload.put("type", "osgi");
            }
            StringBuilder sb = new StringBuilder();
            String sep = "";
            if (deployMap.containsKey("java-web-start-enabled")) {
                if ("false".equals(deployMap.get("java-web-start-enabled"))) {
                    sb.append("java-web-start-enabled").append("=").append("false");
                    sep = ":";
                } else {
                    sb.append("java-web-start-enabled").append("=").append("true");
                    sep = ":";
                }
            }
            if (deployMap.containsKey("preserveAppScopedResources") && "true".equals(deployMap.get("preserveAppScopedResources"))) {
                sb.append(sep).append("preserveAppScopedResources").append("=").append("true");
            }
            if (sb.length() > 0) {
                payload.put("properties", sb.toString());
            }
            if ((targetList = DeployUtil.getApplicationTarget(appName, "application-ref")).size() != 1) {
                payload.put("target", "domain");
            } else {
                payload.put("target", targetList.get(0));
            }
            String prefix = (String)GuiUtil.getSessionValue("REST_URL");
            RestUtil.restRequest(prefix + "/applications/application", payload, "POST", null, true);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void undeploy(HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("selectedRows");
        ArrayList<String> warningList = new ArrayList<String>();
        List selectedRows = (List)obj;
        for (int i = 0; i < selectedRows.size(); ++i) {
            Map oneRow = (Map)selectedRows.get(i);
            String appName = (String)oneRow.get("name");
            List targets = DeployUtil.getApplicationTarget(appName, "application-ref");
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("target", "domain");
            String prefix = (String)GuiUtil.getSessionValue("REST_URL");
            try {
                Map<String, Object> responseMap = RestUtil.restRequest(prefix + "/applications/application/" + appName, payload, "DELETE", null, true, true);
                if (targets.size() > 0) {
                    DeploymentHandler.removeFromDefaultWebModule(appName, targets);
                }
                if (!RestUtil.hasWarning(responseMap)) continue;
                warningList.add(appName);
                continue;
            }
            catch (Exception ex) {
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), ex.getMessage());
                return;
            }
        }
        if (warningList.size() > 0) {
            GuiUtil.prepareAlert("warning", GuiUtil.getCommonMessage("msg.Undeployment.warning"), GuiUtil.getCommonMessage("msg.referToApp") + warningList);
        }
    }

    private static void removeFromDefaultWebModule(String undeployedAppName, List<String> targets) {
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/configs/config/";
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        attrsMap.put("defaultWebModule", "");
        for (String oneTarget : targets) {
            try {
                String endpoint = TargetUtil.getTargetEndpoint(oneTarget);
                String configName = (String)RestUtil.getEntityAttrs(endpoint, "entity").get("configRef");
                String encodedConfigName = URLEncoder.encode(configName, "UTF-8");
                String vsEndpoint = prefix + encodedConfigName + "/http-service/virtual-server";
                Map<String, String> vsMap = RestUtil.getChildMap(vsEndpoint);
                if (vsMap.size() <= 0) continue;
                ArrayList<String> vsList = new ArrayList<String>(vsMap.keySet());
                for (String oneVs : vsList) {
                    String oneEndpoint = vsEndpoint + "/" + oneVs;
                    String defWebModule = (String)RestUtil.getEntityAttrs(oneEndpoint, "entity").get("defaultWebModule");
                    if (GuiUtil.isEmpty(defWebModule)) continue;
                    int index = defWebModule.indexOf("#");
                    if (index != -1) {
                        defWebModule = defWebModule.substring(0, index);
                    }
                    if (!undeployedAppName.equals(defWebModule)) continue;
                    RestUtil.restRequest(oneEndpoint, attrsMap, "POST", null, false);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public static void getDeploymentDescriptorList(HandlerContext handlerCtx) {
        List ddList = (List)handlerCtx.getInputValue("data");
        ArrayList result = new ArrayList();
        if (ddList != null && ddList.size() > 0) {
            for (Map oneDD : ddList) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                Map props = (Map)oneDD.get("properties");
                String mName = (String)props.get(MODULE_NAME_KEY);
                oneRow.put("moduleName", mName == null ? "" : mName);
                String ddPath = (String)props.get(DD_PATH_KEY);
                oneRow.put("ddPath", ddPath == null ? "" : ddPath);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("descriptors", result);
    }

    public static void getDeploymentDescriptor(HandlerContext handlerCtx) {
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        if (moduleName == null) {
            moduleName = "";
        }
        String descriptorName = (String)handlerCtx.getInputValue("descriptorName");
        List ddList = (List)handlerCtx.getInputValue("data");
        if (ddList.size() > 0) {
            for (Map oneDD : ddList) {
                Map props = (Map)oneDD.get("properties");
                if (!moduleName.equals(props.get(MODULE_NAME_KEY)) || !descriptorName.equals(props.get(DD_PATH_KEY))) continue;
                String ddContent = (String)props.get(DD_CONTENT_KEY);
                String content = ddContent == null ? "" : ddContent;
                handlerCtx.setOutputValue("content", (Object)content);
                handlerCtx.setOutputValue("encoding", (Object)DeploymentHandler.getEncoding(content));
            }
        }
    }

    private static String getEncoding(String xmlDoc) {
        String encoding = null;
        TemplateParser parser = new TemplateParser((InputStream)new ByteArrayInputStream(xmlDoc.getBytes()));
        try {
            parser.open();
            encoding = parser.readUntil("encoding", false);
            if (encoding.endsWith("encoding")) {
                parser.readUntil(61, false);
                encoding = (String)parser.getNVP("encoding").getValue();
            } else {
                encoding = null;
            }
        }
        catch (SyntaxException ex) {
            encoding = null;
        }
        catch (IOException ex) {
            encoding = null;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }
}

