/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.listener;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ManagedConnection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalTxConnectionEventListener
extends ConnectionEventListener {
    private static final Logger logger = LogDomains.getLogger(ResourceHandle.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private final PoolManager poolManager = ConnectorRuntime.getRuntime().getPoolManager();
    private final IdentityHashMap<Object, ResourceHandle> associatedHandles = new IdentityHashMap(10);
    private final ResourceHandle resource;

    public LocalTxConnectionEventListener(ResourceHandle resource) {
        this.resource = resource;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener constructor, resource=" + resource + ", this=" + this);
        }
    }

    public synchronized void connectionClosed(ConnectionEvent evt) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed START, resource=" + this.resource + ", this=" + this);
            for (Object key : this.associatedHandles.keySet()) {
                ResourceHandle associatedHandle = this.associatedHandles.get(key);
                logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed associatedHandles: key=" + key + ", handle=" + associatedHandle);
                logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed associatedHandles: resource=" + associatedHandle.getResource());
            }
        }
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        this.poolManager.resourceClosed(handle);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener.connectionClosed END, resource=" + this.resource + ", handle=" + handle + ", this=" + this);
        }
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent evt) {
        this.resource.setConnectionErrorOccurred();
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
        this.poolManager.resourceErrorOccurred(this.resource);
    }

    @Override
    public synchronized void badConnectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
        this.poolManager.badResourceClosed(handle);
    }

    public void localTransactionStarted(ConnectionEvent evt) {
    }

    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    public void localTransactionRolledback(ConnectionEvent evt) {
    }

    public synchronized void associateHandle(Object userHandle, ResourceHandle resourceHandle) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener associateHandle, userHandle=" + userHandle + ", resourceHandle=" + resourceHandle + ", this=" + this);
        }
        this.associatedHandles.put(userHandle, resourceHandle);
    }

    public synchronized ResourceHandle removeAssociation(Object userHandle) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LocalTxConnectionEventListener removeAssociation, userHandle=" + userHandle + ", this=" + this);
        }
        return this.associatedHandles.remove(userHandle);
    }

    public synchronized Map<Object, ResourceHandle> getAssociatedHandlesAndClearMap() {
        logger.log(Level.FINE, "LocalTxConnectionEventListener getAssociatedHandlesAndClearMap, this=" + this);
        IdentityHashMap result = (IdentityHashMap)this.associatedHandles.clone();
        this.associatedHandles.clear();
        return result;
    }
}

