/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.BrokerListProperties;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.util.Vector;

public class ConsoleBrokerAdminManager {
    private String fileName = "brokerlist.properties";
    private Vector admins = new Vector();

    public void addBrokerAdmin(BrokerAdmin ba) {
        this.admins.addElement(ba);
    }

    public void deleteBrokerAdmin(BrokerAdmin ba) {
        String baKey = ba.getKey();
        for (int i = 0; i < this.admins.size(); ++i) {
            BrokerAdmin ba2 = (BrokerAdmin)this.admins.get(i);
            String ba2Key = ba2.getKey();
            if (!baKey.equals(ba2Key)) continue;
            this.admins.remove(i);
            return;
        }
    }

    public void readBrokerAdminsFromFile() throws UserPropertiesException, BrokerAdminException {
        BrokerListProperties blProps = this.readFromFile();
        int count = blProps.getBrokerCount();
        for (int i = 0; i < count; ++i) {
            BrokerAdmin ba = blProps.getBrokerAdmin(i);
            this.addBrokerAdmin(ba);
        }
    }

    public void writeBrokerAdminsToFile() throws UserPropertiesException {
        BrokerListProperties blProps = new BrokerListProperties();
        for (int i = 0; i < this.admins.size(); ++i) {
            BrokerAdmin ba = (BrokerAdmin)this.admins.get(i);
            blProps.addBrokerAdmin(ba);
        }
        this.writeToFile(blProps);
    }

    public Vector getBrokerAdmins() {
        return this.admins;
    }

    public boolean exist(String key) {
        for (int i = 0; i < this.admins.size(); ++i) {
            BrokerAdmin ba = (BrokerAdmin)this.admins.get(i);
            String baKey = ba.getKey();
            if (!key.equals(baKey)) continue;
            return true;
        }
        return false;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private BrokerListProperties readFromFile() throws UserPropertiesException {
        BrokerListProperties blProps = new BrokerListProperties();
        blProps.setFileName(this.fileName);
        blProps.load();
        return blProps;
    }

    private void writeToFile(BrokerListProperties blProps) throws UserPropertiesException {
        blProps.setFileName(this.fileName);
        blProps.save();
    }
}

