/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.MediaType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.adapter.CdiBridge;
import org.glassfish.admin.rest.adapter.Reloader;
import org.glassfish.admin.rest.adapter.RestResourceProvider;
import org.glassfish.admin.rest.resources.ReloadResource;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.CsrfProtectionFilter;

public abstract class AbstractRestResourceProvider
implements RestResourceProvider,
Serializable {
    protected Map<String, MediaType> mappings;

    protected AbstractRestResourceProvider() {
    }

    @Override
    public boolean enableModifAccessToInstances() {
        return false;
    }

    protected Map<String, MediaType> getMimeMappings() {
        if (this.mappings == null) {
            this.mappings = new HashMap<String, MediaType>();
            this.mappings.put("xml", MediaType.APPLICATION_XML_TYPE);
            this.mappings.put("json", MediaType.APPLICATION_JSON_TYPE);
            this.mappings.put("html", MediaType.TEXT_HTML_TYPE);
            this.mappings.put("js", new MediaType("text", "javascript"));
        }
        return this.mappings;
    }

    protected Feature getJsonFeature() {
        return new JettisonFeature();
    }

    @Override
    public ResourceConfig getResourceConfig(Set<Class<?>> classes, ServerContext serverContext, ServiceLocator serviceLocator, Set<? extends Binder> additionalBinders) throws EndpointRegistrationException {
        RestLogging.restLogger.log(Level.FINEST, () -> "Configuring binding with " + this);
        ResourceConfig rc = new ResourceConfig(classes);
        rc.property("jersey.config.server.mediaTypeMappings", this.getMimeMappings());
        rc.register(CsrfProtectionFilter.class);
        Reloader reloader = new Reloader();
        rc.register((Object)new CdiBridge(serviceLocator, reloader, serverContext));
        rc.register((Object)reloader);
        rc.register(ReloadResource.class);
        rc.register((Object)new MultiPartFeature());
        for (Binder binder : additionalBinders) {
            rc.register((Object)binder);
        }
        rc.property("jersey.config.workers.legacyOrdering", (Object)true);
        RestLogging.restLogger.log(Level.CONFIG, () -> "Configured binding with " + this + " for classes: " + rc.getClasses());
        return rc;
    }
}

