/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.persistence.EntityManagerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public abstract class AppClientInfo {
    private static final LocalStringManager I18N = new LocalStringManagerImpl(AppClientInfo.class);
    private static final boolean KEEP_EXPLODED_DIR = Boolean.getBoolean("appclient.keep.exploded.dir");
    protected Logger _logger;
    protected String mainClassFromCommandLine;
    protected String mainClassNameToRun;
    protected boolean isJWS;
    private ApplicationClientDescriptor acDesc;

    public AppClientInfo(boolean isJWS, Logger logger, String mainClassFromCommandLine) {
        this.isJWS = isJWS;
        this._logger = logger;
        this.mainClassFromCommandLine = mainClassFromCommandLine;
    }

    protected void setDescriptor(ApplicationClientDescriptor acDesc) {
        this.acDesc = acDesc;
    }

    protected ApplicationClientDescriptor getDescriptor() {
        return this.acDesc;
    }

    protected void completeInit() throws Exception {
    }

    protected ApplicationClientDescriptor getAppClient() {
        return this.getAppClient(null);
    }

    protected ClassLoader getClassLoader() {
        return null;
    }

    protected void close() throws IOException {
    }

    protected boolean deleteAppClientDir() {
        return !KEEP_EXPLODED_DIR;
    }

    protected String getLocalString(String key, String defaultMessage, Object ... args) {
        String result = I18N.getLocalString(this.getClass(), key, defaultMessage, args);
        return result;
    }

    protected void handlePersistenceUnitDependency() throws URISyntaxException, MalformedURLException {
    }

    protected boolean descriptorContainsPURefcs(ApplicationClientDescriptor descr) {
        return !descr.getEntityManagerFactoryReferenceDescriptors().isEmpty();
    }

    protected static URL getEntryAsUrl(File moduleLocation, String uri) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url != null) {
            return url;
        }
        if (moduleLocation != null) {
            if (moduleLocation.isFile()) {
                url = AppClientInfo.createJarUrl(moduleLocation, uri);
            } else {
                String path = uri.replace('/', File.separatorChar);
                url = new File(moduleLocation, path).toURI().toURL();
            }
        }
        return url;
    }

    private static URL createJarUrl(File jarFile, String entry) throws MalformedURLException, IOException {
        return new URL("jar:" + jarFile.toURI().toURL() + "!/" + entry);
    }

    protected ApplicationClientDescriptor getAppClient(Archivist archivist) {
        return (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(archivist.getDescriptor());
    }

    protected String getAppClientRoot(ReadableArchive archive, ApplicationClientDescriptor descriptor) {
        return archive.getURI().toASCIIString();
    }

    protected void massageDescriptor() throws IOException, AnnotationProcessorException {
    }

    protected List<String> getClassPaths(ReadableArchive archive) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(archive.getURI().toASCIIString());
        return paths;
    }

    protected String getMainClassNameToRun(ApplicationClientDescriptor acDescr) {
        if (this.mainClassNameToRun == null) {
            if (this.mainClassFromCommandLine != null) {
                this.mainClassNameToRun = this.mainClassFromCommandLine;
                this._logger.fine("Main class is " + this.mainClassNameToRun + " from command line");
            } else {
                this.mainClassNameToRun = this.getAppClient().getMainClassName();
                this._logger.fine("Main class is " + this.mainClassNameToRun + " from descriptor");
            }
        }
        return this.mainClassNameToRun;
    }

    protected boolean classContainsAnnotation(String entry, AnnotationDetector detector, ReadableArchive archive, ApplicationClientDescriptor descriptor) throws FileNotFoundException, IOException {
        return detector.containsAnnotation(archive, entry);
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + ": " + lineSep);
        result.append("  isJWS: " + this.isJWS);
        result.append("  main class to be run: " + this.mainClassNameToRun + lineSep);
        return result.toString();
    }

    private static class ApplicationInfoImpl {
        private final AppClientInfo outer;
        private final ApplicationClientDescriptor appClient;

        public ApplicationInfoImpl(AppClientInfo outer) {
            this.outer = outer;
            this.appClient = outer.getAppClient();
        }

        public Application getApplication(ServiceLocator habitat) {
            Application application = this.appClient.getApplication();
            if (application == null) {
                application = Application.createVirtualApplication((String)this.appClient.getModuleID(), (ModuleDescriptor)this.appClient.getModuleDescriptor());
            }
            return application;
        }

        public InstrumentableClassLoader getClassLoader() {
            return (InstrumentableClassLoader)this.outer.getClassLoader();
        }

        public Collection<? extends PersistenceUnitDescriptor> getReferencedPUs() {
            return this.appClient.findReferencedPUs();
        }

        public Collection<? extends EntityManagerFactory> getEntityManagerFactories() {
            HashSet emfs = new HashSet();
            if (this.appClient.getApplication() != null) {
                emfs.addAll(this.appClient.getApplication().getEntityManagerFactories());
            }
            emfs.addAll(this.appClient.getEntityManagerFactories());
            return emfs;
        }
    }
}

