/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import java.util.Hashtable;
import java.util.List;

public class ResetMetricsHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ResetMetricsHandler.getDEBUG();

    public ResetMetricsHandler(AdminDataHandler parent) {
        super(parent);
    }

    public static void resetAllMetrics() {
        Globals.getDestinationList();
        DestinationList.resetAllMetrics(null);
        Globals.getServiceManager();
        List services = ServiceManager.getAllServiceNames();
        for (String name : services) {
            IMQService service = (IMQService)Globals.getServiceManager().getService(name);
            if (service == null) continue;
            service.resetCounters();
        }
        MetricManager mm = Globals.getMetricManager();
        mm.reset();
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.resetMetrics();
        }
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + String.valueOf(cmd_props));
        }
        int status = 200;
        String errMsg = null;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else {
            String resetType = (String)cmd_props.get("JMQResetType");
            if (resetType == null || resetType.equals("")) {
                this.logger.log(8, "B1247");
                ResetMetricsHandler.resetAllMetrics();
            } else if ("JMQMetrics".equals(resetType)) {
                this.logger.log(8, "B1247");
                ResetMetricsHandler.resetAllMetrics();
            } else {
                this.logger.log(32, "B3216", resetType);
                errMsg = this.rb.getString("B3216", resetType);
                status = 500;
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        ResetMetricsHandler.setProperties(reply, 85, status, errMsg, null);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

