/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.plugin.spi.CoreLifecycleSpi;
import com.sun.messaging.jmq.jmsserver.service.ConnectionClosedListener;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public abstract class Connection {
    private static int clockSkewTime = Globals.getConfig().getIntProperty("imq.clock.skew.interval", 300);
    private static int clockSkewCheck = Globals.getConfig().getIntProperty("imq.clock.skew.checkCnt", 0);
    private int skewCheckCounter = 0;
    private long lastAccess = 0L;
    private long lastResponse = 0L;
    protected final Logger logger = Globals.getLogger();
    public static final int UNKNOWN_PROTOCOL = -1;
    public static final int SWIFT_PROTOCOL = 200;
    public static final int HUMMINGBIRD_PROTOCOL = 201;
    public static final int FALCON_PROTOCOL = 300;
    public static final int RAPTOR_PROTOCOL = 350;
    public static final int SHRIKE_PROTOCOL = 360;
    public static final int SHRIKE4_PROTOCOL = 364;
    public static final int HAWK_PROTOCOL = 400;
    public static final int MQ450_PROTOCOL = 450;
    public static final int MQ500_PROTOCOL = 500;
    public static final int STATE_UNAVAILABLE = -1;
    public static final int STATE_CONNECTED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_AUTH_REQUESTED = 2;
    public static final int STATE_AUTH_RESPONSED = 3;
    public static final int STATE_AUTHENTICATED = 4;
    public static final int STATE_CLEANED = 5;
    public static final int STATE_CLOSED = 6;
    public static final int STATE_DESTROYING = 7;
    public static final int STATE_DESTROYED = 8;
    protected int state = -1;
    protected Service service = null;
    protected AccessController accessController = null;
    protected ConnectionUID conId = null;
    protected long reconnectInterval = 0L;
    protected int clientProtocolVersion = -1;
    protected Hashtable clientData = null;
    protected boolean isadmin = false;
    protected List consumerInfoRequests = Collections.synchronizedList(new ArrayList());
    protected List connCloseListeners = new ArrayList();
    protected CoreLifecycleSpi coreLifecycle = null;

    public Connection(Service svc) throws BrokerException {
        this.setService(svc);
        this.isadmin = svc.getServiceType() == 1;
    }

    public void setCoreLifecycle(CoreLifecycleSpi clc) {
        this.coreLifecycle = clc;
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("uid", String.valueOf(this.conId.longValue()));
        ht.put("service", this.service.toString());
        ht.put("state", Connection.getConnectionStateString(this.state));
        if (this.clientData != null) {
            ht.put("clientData", this.clientData.toString());
        } else {
            ht.put("clientData", "none");
        }
        ht.put("clientProtocol", String.valueOf(this.clientProtocolVersion));
        ht.put("reconnectInterval", String.valueOf(this.reconnectInterval));
        ht.put("lastAccess", String.valueOf(this.lastAccess));
        ht.put("lastResponse", String.valueOf(this.lastResponse));
        return ht;
    }

    public void setReconnectInterval(long val) {
        this.reconnectInterval = val;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public boolean isAdminConnection() {
        return this.isadmin;
    }

    public static int getHighestSupportedProtocol() {
        return 500;
    }

    public abstract void startConnection();

    public abstract void stopConnection();

    public abstract void cleanupConnection();

    public abstract void closeConnection(boolean var1, int var2, String var3);

    public abstract void shutdownConnection(String var1);

    public void destroyConnection(boolean force, int reason, String reasonStr) {
        this.service.removeConnection(this.conId, reason, reasonStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnectionClosed() {
        Connection connection = this;
        synchronized (connection) {
            Iterator itr = this.connCloseListeners.iterator();
            ConnectionClosedListener l = null;
            while (itr.hasNext()) {
                l = (ConnectionClosedListener)itr.next();
                l.connectionClosed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionClosedListener(ConnectionClosedListener l) {
        Connection connection = this;
        synchronized (connection) {
            this.connCloseListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionClosedListener(ConnectionClosedListener l) {
        Connection connection = this;
        synchronized (connection) {
            this.connCloseListeners.remove(l);
        }
    }

    public abstract void logConnectionInfo(boolean var1);

    public abstract String getRemoteConnectionString();

    public ConnectionUID getConnectionUID() {
        return this.conId;
    }

    public void setConnectionUID(ConnectionUID conId) {
        this.conId = conId;
    }

    protected void setService(Service id) {
        this.service = id;
    }

    public Service getService() {
        return this.service;
    }

    public void setClientProtocolVersion(int version) {
        this.clientProtocolVersion = version;
    }

    public int getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    public AccessController getAccessController() {
        return this.accessController;
    }

    public Principal getAuthenticatedName() throws BrokerException {
        return this.accessController.getAuthenticatedName();
    }

    public boolean setConnectionState(int state) {
        if (state >= 8) {
            return true;
        }
        this.state = state;
        return false;
    }

    public static String getConnectionStateString(int state) {
        switch (state) {
            case -1: {
                return "UNAVAILABLE";
            }
            case 0: {
                return "CONNECTED";
            }
            case 1: {
                return "INITIALIZED";
            }
            case 2: {
                return "AUTHENTICATION REQUESTED";
            }
            case 3: {
                return "AUTHENTICATION RESPONSED";
            }
            case 4: {
                return "AUTHENTICATED";
            }
            case 6: {
                return "CLOSED";
            }
            case 5: {
                return "CLEANED";
            }
            case 7: {
                return "DESTROYING";
            }
            case 8: {
                return "DESTROYED";
            }
        }
        return "UNKNOWN";
    }

    public int getConnectionState() {
        return this.state;
    }

    public void addClientData(String name, Object data) {
        if (this.clientData == null) {
            this.clientData = new Hashtable();
        }
        this.clientData.put(name, data);
    }

    public void removeClientData(String name) {
        if (this.clientData == null) {
            return;
        }
        this.clientData.remove(name);
    }

    public Object getClientData(String name) {
        if (this.clientData == null) {
            return null;
        }
        return this.clientData.get(name);
    }

    public void updateAccessTime(boolean received) {
        this.lastAccess = System.currentTimeMillis();
        if (received) {
            this.lastResponse = this.lastAccess;
        }
    }

    public long getAccessTime() {
        return this.lastAccess;
    }

    public long getLastResponseTime() {
        return this.lastResponse;
    }

    public void checkClockSkew(long receivetime, long sendtime, long expiretime, long deliverytime) {
        if (clockSkewCheck < 0) {
            return;
        }
        if (clockSkewCheck == 0 && this.skewCheckCounter > 0) {
            return;
        }
        ++this.skewCheckCounter;
        if (clockSkewCheck > 0 && this.skewCheckCounter % clockSkewCheck != 0) {
            return;
        }
        long skewSecsMS = Math.abs(sendtime - receivetime);
        long skewSecs = skewSecsMS / 1000L;
        long expirationMS = expiretime == 0L ? 0L : (receivetime > sendtime ? expiretime - sendtime : 0L);
        long expirationSecs = expirationMS / 1000L;
        if (skewSecs > (long)clockSkewTime) {
            String msg = "B2102";
            if (sendtime < receivetime) {
                msg = "B2103";
            }
            this.logger.log(16, msg, (Object)this.getRemoteConnectionString(), String.valueOf(clockSkewTime));
        } else if (expirationMS != 0L && expirationSecs < (long)clockSkewTime && expirationMS < 2L * skewSecsMS) {
            this.logger.log(16, "B2104", this.getRemoteConnectionString());
        }
    }

    protected abstract void sayGoodbye(int var1, String var2);

    protected abstract void flushConnection(long var1);

    protected abstract void checkConnection();

    public abstract void cleanupMemory(boolean var1);

    public void debug(String prefix) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConsumerInfo(int requestType, DestinationUID duid, int destType, int infoType, boolean sendToWildcard) {
        DestinationUID uid2 = null;
        List list = this.consumerInfoRequests;
        synchronized (list) {
            for (DestinationUID uid2 : this.consumerInfoRequests) {
                if (!uid2.isWildcard()) {
                    if (!duid.equals(uid2)) continue;
                    this.sendConsumerInfo(requestType, uid2.getName(), destType, infoType);
                    break;
                }
                if (duid.isWildcard() && uid2.getName().equals(duid.getName()) && duid.isQueue() == uid2.isQueue()) {
                    this.sendConsumerInfo(requestType, uid2.getName(), destType, infoType);
                    break;
                }
                if (!DestinationUID.match(duid, uid2)) continue;
                if (sendToWildcard) {
                    this.sendConsumerInfo(requestType, uid2.getName(), destType, infoType);
                    continue;
                }
                Globals.getConnectionManager().getConsumerInfoNotifyManager().consumerInfoRequested(this, uid2, destType, infoType);
            }
        }
    }

    protected abstract void sendConsumerInfo(int var1, String var2, int var3, int var4);

    public void addConsumerInfoRequest(DestinationUID duid) {
        this.consumerInfoRequests.add(duid);
    }

    public void removeConsumerInfoRequest(DestinationUID duid) {
        this.consumerInfoRequests.remove(duid);
    }
}

